//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of cmlogDataManager
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogDataManager.cc,v $
//   Revision 1.1.1.1  1999/09/07 15:29:10  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:27:16  bickley
// Added cmlog to application development system.
//
//
//
#include <cmlogData.h>
#include "cmlogDataManager.h"

const int CMLOG_DATA_TABLE_SIZE = 107;

cmlogDataManager::cmlogDataManager (void)
:dataTable_ (CMLOG_DATA_TABLE_SIZE, cmlogStrHashFunc)
{
#ifdef _TRACE_OBJECTS
  printf ("Create cmlogDataManager Class Object\n");
#endif
}

cmlogDataManager::~cmlogDataManager (void)
{
#ifdef _TRACE_OBJECTS
  printf ("Delete cmlogDataManager Class Object\n");
#endif
  freeAll ();
  cleanAll ();
}

void
cmlogDataManager::cleanAll (void)
{
  dataTable_.deleteAllValues ();
}

void
cmlogDataManager::freeAll (void)
{
  cmlogStrHashIterator ite (dataTable_);
  cmlogData* data = 0;

  for (ite.init (); !ite; ++ite){
    data = (cmlogData *)ite ();
#ifdef _CMLOG_DEBUG
    printf ("Remove data Variables %s\n",data->name());
#endif
    delete data;
  }
}

int
cmlogDataManager::hasData (char *name)
{
  cmlogSlist& list = dataTable_.bucketRef (name);
  cmlogSlistIterator ite (list);
  cmlogData *data = 0;

  for (ite.init(); !ite; ++ite){
    data = (cmlogData *)ite ();
    if (::strcmp (name, data->name ()) == 0)
      return 1;
  }
  return 0;
}

int
cmlogDataManager::addData (cmlogData *data)
{
  if (hasData (data->name ()))
    return -1;
  dataTable_.add (data->name (), (void *)data);
  return 0;
}

int
cmlogDataManager::removeData (cmlogData *data)
{
  if (!hasData (data->name ()))
    return -1;
  dataTable_.remove (data->name (), (void *)data);
  return 0;
}

int
cmlogDataManager::removeData (char *name)
{
  cmlogSlist& list = dataTable_.bucketRef (name);
  cmlogSlistIterator ite (list);
  cmlogData *data = 0;

  for (ite.init(); !ite; ++ite){
    data = (cmlogData *)ite ();
    if (::strcmp (name, data->name ()) == 0){
      list.remove ((void *)data);
      delete data;
      return 0;
    }
  }
  return -1;
}

int
cmlogDataManager::findData (char *name, cmlogData* &data)
{
  cmlogSlist& list = dataTable_.bucketRef (name);
  cmlogSlistIterator ite (list);
  cmlogData *tdata = 0;

  for (ite.init(); !ite; ++ite){
    tdata = (cmlogData *)ite ();
    if (::strcmp (name, tdata->name ()) == 0){
      data = tdata;
      return 0;
    }
  }
  data = 0;
  return -1;
}

void
cmlogDataManager::asciiDump (FILE* fd)
{
  cmlogStrHashIterator ite (dataTable_);
  cmlogData* data = 0;

  for (ite.init (); !ite; ++ite){
    data = (cmlogData *)ite ();
    data->asciiDump (fd);
  }  
}

void
cmlogDataManager::update (void)
{
  cmlogStrHashIterator ite (dataTable_);
  cmlogData* data = 0;

  for (ite.init (); !ite; ++ite){
    data = (cmlogData *)ite ();
    data->update ();
  }  
}

void
cmlogDataManager::removeCbksOfCh (void* ch) 
{
  cmlogStrHashIterator ite (dataTable_);
  cmlogData* data = 0;

  for (ite.init (); !ite; ++ite){
    data = (cmlogData *)ite ();
    data->removeAllCbksOfCh (ch);
  }  
}

//=========================================================================
//         Implementation of iterator
//=========================================================================
cmlogDataManagerIterator::cmlogDataManagerIterator (cmlogDataManager& manager)
:ite_ (manager.dataTable_)
{
#ifdef _TRACE_OBJECTS
  printf ("Create cmlogDataManager Iterator Class Obejct\n");
#endif
  // empty
}

cmlogDataManagerIterator::~cmlogDataManagerIterator (void)
{
#ifdef _TRACE_OBJECTS
  printf ("Delete cmlogDataManager Iterator Class Obejct\n");
#endif
  // empty
}

int
cmlogDataManagerIterator::init (void)
{
  return ite_.init ();
}

cmlogData*
cmlogDataManagerIterator::operator () (void)
{
  return (cmlogData *)ite_ ();
}

int
cmlogDataManagerIterator::operator ! (void)
{
  return !ite_;
}

int
cmlogDataManagerIterator::operator ++ (void)
{
  return ++ite_;
}
