//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      CMLOG cdevData cached list for query purpose
//      Internally this is just a sorted list according to a key (double)
//      in increasing order
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogDataCache.h,v $
//   Revision 1.1.1.1  1999/09/07 15:29:10  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:27:15  bickley
// Added cmlog to application development system.
//
//
//
#ifndef _CMLOG_DATA_CACHE_H
#define _CMLOG_DATA_CACHE_H

#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <cmlogSlist.h>

class cmlogDataCache: public cmlogSlist
{
public:
  // constructor and destructor
  cmlogDataCache  (void);
  ~cmlogDataCache (void);

  // change implementation of add
  virtual void add (void* data);
  // change implementation of count
  virtual int  count (void);

  // return first key which is smallest key in the cache
  int          firstKey     (double* key);

  // print out everything
  void         asciiDump    (FILE* fp = stdout);

private:
  // int to keep current number of elements
  int                 num_;
  // deny access to copy and assignment operator
  cmlogDataCache (const cmlogDataCache& cache);
  cmlogDataCache& operator = (const cmlogDataCache& cache);
};
#endif
