//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of cmlogDataCache Class
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogDataCache.cc,v $
//   Revision 1.2  2001/07/25 14:26:36  chen
//   64 BIT Initial Port
//
//   Revision 1.1.1.1  1999/09/07 15:29:10  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:27:13  bickley
// Added cmlog to application development system.
//
//
//
#include <cmlogUtil.h>
#include <cdevData.h>
#include "cmlogDataCache.h"


// number of cdevData cached in the memory
#define CMLOG_CACHED_DATA 64

cmlogDataCache::cmlogDataCache (void)
:cmlogSlist (), num_ (0)
{
#ifdef _TRACE_OBJECTS
  printf ("    Create cmlogDataCache Class Object\n");
#endif
  // empty
}

cmlogDataCache::~cmlogDataCache (void)
{
#ifdef _TRACE_OBJECTS
  printf ("    Delete cmlogDataCache Class Object\n");
#endif

#if defined (CMLOG_USE_THREAD) && defined (_REENTRANT)
  cpMutexGuard guard (lock_);
#endif

  cmlogSlistLink *p = 0;
  cdevData* data = 0;

  for (p = ptrToFirstLink; p; p = p->next ()) {
    data = (cdevData *)p->data ();
    delete data;
  }
}

int
cmlogDataCache::firstKey (double* key)
{
#if defined (CMLOG_USE_THREAD) && defined (_REENTRANT)
  cpMutexGuard guard (lock_);
#endif

  if (num_ == 0)
    return -1;

  cdevData* data = (cdevData *)firstElement_i ();
  if (data->get (cmlogUtil::CMLOG_KEY_TAG, key) == CDEV_SUCCESS)
    return 0;
  return -1;
}

void
cmlogDataCache::add (void* d)
{
#if defined (CMLOG_USE_THREAD) && defined (_REENTRANT)
  cpMutexGuard guard (lock_);
#endif

  cdevData*   data = 0;
  if (num_ >= CMLOG_CACHED_DATA) { 
    // exceed number of data in the cache, remove the oldest data item
    data = (cdevData *)firstElement_i ();
    delete data;
    removeFirst_i ();
    num_ --;
  }
  
  cdevData*   val = (cdevData *)d;
  double      key0, key1;

  if (val->get (cmlogUtil::CMLOG_KEY_TAG, &key0) != CDEV_SUCCESS)
    return;

  if (num_ == 0) { // empty list
    cmlogSlist::add_i (d);
    num_ ++;
  }
  else {
    cmlogSlistLink *p = ptrToFirstLink;
    cmlogSlistLink *prev = p;

    while (p) {
      data = (cdevData *)p->data ();
      if (data->get (cmlogUtil::CMLOG_KEY_TAG, &key1) == CDEV_SUCCESS &&
	  key0 < key1) {
	if (p == prev)  // first one
	  ptrToFirstLink = new cmlogSlistLink (d, ptrToFirstLink);
	else
	  prev->insert (d);
	num_ ++;
	return;
      }
      prev = p;
      p = p->next ();
    }
    // add to the end of the list
    prev->insert (d);
    num_ ++;
  }
}

int
cmlogDataCache::count (void)
{
  return num_;
}

void
cmlogDataCache::asciiDump (FILE* fp)
{
  cdevData* data = 0;
  cmlogSlistIterator ite (*this);

  for (ite.init (); !ite; ++ite) {
    data = (cdevData *)ite ();
    data->asciiDump (fp);
  }
}

  

    
    
