//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      Data Object that kept internal information of the Server
//      Data are keyed by a name
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogData.h,v $
//   Revision 1.2  2001/07/25 14:26:36  chen
//   64 BIT Initial Port
//
//   Revision 1.1.1.1  1999/09/07 15:29:10  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:27:12  bickley
// Added cmlog to application development system.
//
//
//
#ifndef _CMLOG_DATA_H
#define _CMLOG_DATA_H

#include <stdio.h>
#include <string.h>
#include <cmlogSlist.h>
#include <cdevData.h>
#include <cmlogDataManager.h>

#if defined (CMLOG_USE_THREAD) && defined (_REENTRANT)
#include <cpSynch.h>
#endif

class cmlog_cdevMessage;

class cmlogData
{
public:
  // constructors
  cmlogData             (char* name);
  cmlogData             (char* name, const cdevData& data);
  

  // destructor
  virtual ~cmlogData            (void);

  // operations
  // return 0: for success, -1: failure
  
  // connect/disconnect to/from the data manager
  int connect           (cmlogDataManager& manager);
  int disconnect        (cmlogDataManager& manager);

  // monitorOn/Off methods
  int monitorOn         (cmlog_cdevMessage* channel);
  int monitorOff        (cmlog_cdevMessage* channel);
  int monitored         (void);

  // assignment operation
  cmlogData& operator = (const cdevData& newdata);
  // retrieve data
  operator cdevData&    (void);

  // retrieve name of this object
  char* name            (void) const;

  // update memory from database file
  virtual void update   (void);
  // in case of any change in value, send new value to all interested
  // parties: only works for browser part
  virtual void notifyChannels (void);

  // send result back to callers according to the request message
  virtual void getValue       (cmlog_cdevMessage* request);

  // remove all callbacks from the a browserIO channel (denoted by pointer)
  virtual void removeAllCbksOfCh (void* channel);

  // ascii dump
  void         asciiDump (FILE* fd = stdout);
  
  // callback list
  cmlogSlist&           getCbkList        (void);
  cmlogSlist&           monitorCbkList    (void);
  cmlogSlist&           monitorOffCbkList (void);

protected:
  // check whether two cmlog_cdevMessage are the same or not
  // if checkreq == 1, include checking reqid, else do not care reqid
  static int  sameMessage (cmlog_cdevMessage* msg1, cmlog_cdevMessage* msg2, 
			   int checkreq = 1);

  // name of this object
  char*    name_;
  // real data object
  cdevData data_;

#if defined (CMLOG_USE_THREAD) && defined (_REENTRANT)
  cpMutex lock_;
#endif

  // all callback list contain the cmlog_cdevMessage
  // short      clientID;             -> client id from logging side
  // unsigned   transIndex;           -> browser request index
  // unsigned   cancelTransIndex;     -> not used
  // unsigned   localDataIndex;       -> not used
  // unsigned   foreignDataIndex;     -> event id from browser
  // unsigned   operationCode;        -> operation code
  // unsigned   deviceCount;          -> not used
  // char **    deviceList;           -> not used
  // char *     message;              -> not used
  // cdevData * data;                 -> not used
  // cdevData * context;              -> not used
  // cdevData * tagMap;               -> not used
  // void     * arg;                  -> cmlogIO channel pointer

  // get callback list
  cmlogSlist getCbkList_;
  // monitorOn callback list
  cmlogSlist channels_;
  // montiorOff callback list
  cmlogSlist offCbkList_;
};
#endif

