//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      cmlog server connection context data cache
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogCxtDataCache.h,v $
//   Revision 1.1.1.1  1999/09/07 15:29:09  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:27:10  bickley
// Added cmlog to application development system.
//
//
//
#ifndef _CMLOG_CXT_DATA_CACHE_H
#define _CMLOG_CXT_DATA_CACHE_H

#include <stdio.h>
#include <cmlogIntHash.h>
#include <cdevData.h>

class cmlogCxtDataCache
{
public:
  cmlogCxtDataCache  (char* filename);
  ~cmlogCxtDataCache (void);

  // get a cdevData from cache indexed by a time stamp (double)
  // return just pointer: caller handle this pointer carefully
  cdevData* getCxt   (double stamp);

protected:
  // size of this table
  static unsigned int cacheSize;
  
  // load data from database to cache
  int                 loadDataToCache (char* filename);
  
private:
  // err bit for opening database file
  int err_;
  // hash table keeps all the data keyed by time stamp
  cmlogIntHash table_;
};
#endif
