#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <cmlogClient.h>

main (int argc, char** argv)
{
  if (argc == 1) {
    fprintf (stderr, "Usage: %s \"Message\" \n", argv[0]);
    exit (1);
  }

  char input[1024];
  strncpy (input, argv[1], sizeof (input));
  
  cmlogClient client;

  if (client.connect () != CMLOG_SUCCESS) {
    fprintf (stderr, "Cannot connect to a cmlog server. \n");
    fprintf (stderr, "Check whether cmlogClientD is running or \n");
    fprintf (stderr, "check CMLOG_HOST and CMLOG_PORT environment variables,\n");
    exit (1);

  }
  
  cdevData data;
  data.insert ("facility", argv[0]);
  data.insert ("text", input);
  data.insert ("status", 0);
  data.insert ("severity", 0);
  data.insert ("code", 0);
  
  if (client.postData (data) != CMLOG_SUCCESS) {
    fprintf (stderr, "Sending message to cmlogServer failed\n");
    exit (1);
  }

  client.disconnect ();

  return 0;
}
