//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//     CMLOG Browser Request Object
//
// Author:  Jie Chen
//
// Revision History:
//   $Log: cmlogQRequestObject.h,v $
//   Revision 1.1.1.1  1999/09/07 15:29:09  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/09/18  14:28:56  chen
// new cmlog query service
//
//
//
//
#ifndef _CMLOG_Q_REQUEST_OBJECT_H
#define _CMLOG_Q_REQUEST_OBJECT_H

#include <cdevSystem.h>
#include <cdevRequestObject.h>

class cmlogBrowser;
class cmlogQService;
class cmlogQUpdateObj;

class cmlogQRequestObject: public cdevRequestObject
{
public:
  // constructor and destructor
  cmlogQRequestObject (char* device,
		       char* msg,
		       cmlogQService* svc,
		       cdevSystem& system = cdevSystem::defaultSystem());
  ~cmlogQRequestObject (void);

  int send (cdevData& out, cdevData& result);
  int send (cdevData *out, cdevData& result);
  int send (cdevData& out, cdevData* result);
  int send (cdevData *out, cdevData* result);
  // PURPOSE: Synchronous IO operations "query"
  // REQUIRE: When query result must be provided
  // PROMISE: return CDEV_SUCCESS: success. 

  int sendNoBlock (cdevData& out, cdevData& result);
  int sendNoBlock (cdevData* out, cdevData& result);
  int sendNoBlock (cdevData& out, cdevData* result);
  int sendNoBlock (cdevData* out, cdevData* result);
  // PURPOSE: Asynchronous IO operations used in conjunction with cdevGroup or system
  // REQUIRE: 
  // PROMISE: return CDEV_SUCCESS: requests have been sent out. 

  int sendCallback (cdevData& out, cdevCallback& callback);
  int sendCallback (cdevData* out, cdevCallback& callback);
  // PURPOSE: Asynchromous IO operations with a user supplied callback function
  // REQUIRE: 
  // PROMISE: User callback function will be called with status information
  //          status = CDEV_DISCONNECTED: channel discconected
  //          status = CDEV_SUCCESS     : everything is OK
  //          status = CDEV_ERROR       : something fishy. 
  //          status = CMLOG_INCOMPLETE : data flow will coming (88)
  //          status = CMLOG_CBK_FINISHED: query callback finished (89)
  //          status = CMLOG_PAUSED     : query callback is paused (90)
  //                   When one privde how many to get
  //          status = CMLOG_QUERYMSG_ERR: query message syntax erro (91)

  int getState (void);
  // PURPOSE: get connection state
  // REQUIRE: none
  // PROMISE: CDEV_CONNECTED or CDEV_NOTCONNECTED

  const char *className (void) const {return "cmlogQRequestObject";}

protected:
  // find out action from message
  static int findAction (char* msg, int& action);

  // action value
  static enum {QUERY = 0x1000, UPDATE, UPDATEOFF, UNKNOWN} cmlogQEnumVerb_;

  // real query operation
  int    query (cdevData& data, cmlogBrCallback cbk, void* arg);

  // real update operation
  int    update (cdevData* data, cmlogBrCallback cbk, void* arg);

  // callback function 
  static void queryCallback (int status, void* arg, cmlogPacket* data);

  // callback function 
  static void updateCallback (int status, void* arg, cmlogPacket* data);

  // process result
  static void processResult (int status, cmlogPacket* packet, 
			     cmlogQUpdateObj* obj);

  // remove update callback
  int         removeUpdateCallback (char* attr, cmlogBrCallback callback,
				    void* arg);

  // remove query callback stuff
  int         removeQueryCallback  (cmlogQUpdateObj* uobj);

  // update off all
  int         updateOffAll         (cmlogQService* qsvc);
  // update off one callback       
  int         updateOff            (cdevCallback& callback);

private:
  // action type
  int action_;

  // pointer of underlying client connection
  cmlogBrowser* browser_;
};
#endif

  
