//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      CMLOG Client Request Object Class
//
// Author:  Jie Chen
//
// Revision History:
//   $Log: cmlogRequestObject.cc,v $
//   Revision 1.1.1.1  1999/09/07 15:29:09  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:26:25  bickley
// Added cmlog to application development system.
//
//
//
#include <cdevErrCode.h>
#include <cdevCommon.h>
#include <cdevDirectory.h>
#include <cmlogClient.h>

#include "cmlogRequestObject.h"
#include "cmlogService.h"

cmlogRequestObject::cmlogRequestObject (char* device, char* msg,
					cmlogService* svc,
					cdevSystem& system)
:cdevRequestObject (device, msg, system), contextSet_ (0), client_ (0)
{
#ifdef _TRACE_OBJECTS
  printf ("             Create cmlogRequestObject Class Object\n");
#endif
  // get pointer of real client handler
  client_ = &(svc->client_);
}

cmlogRequestObject::~cmlogRequestObject (void)
{
#ifdef _TRACE_OBJECTS
  printf ("             Delete cmlogRequestObject Class Object\n");
#endif
}

int
cmlogRequestObject::setContext (cdevData& data)
{
  cdevRequestObject::setContext (data);

  // check cdevData empty or not
  cdevDataIterator ite (&data_);
  int empty = 1;

  for (ite.init (); !ite; ++ite) {
    empty = 0;
    break;
  }
  if (!empty) 
    contextSet_ = 1;

  return CDEV_SUCCESS;
}

int
cmlogRequestObject::getState (void)
{
  if (client_->connected ())
    return CDEV_STATE_CONNECTED;
  else
    return CDEV_STATE_NOTCONNECTED;
}

int
cmlogRequestObject::send (cdevData& out, cdevData& result)
{
  return send (&out, &result);
}

int
cmlogRequestObject::send (cdevData* out, cdevData& result)
{
  return send (out, &result);
}

int
cmlogRequestObject::send (cdevData& out, cdevData* result)
{
  return send (&out, result);
}

int
cmlogRequestObject::send (cdevData* out, cdevData* result)
{
  int status = CDEV_ERROR;

  if (!out)
    return CDEV_INVALIDARG;

  if (!client_->connected ()) {
    if (contextSet_) {
      if (client_->connect (data_) != CMLOG_SUCCESS) {
	system_.reportError (CDEV_SEVERITY_SEVERE, deviceName_, this, 
			     "Cannot connect to cmlogClient Daemon\n");
	return CDEV_ERROR;
      }
    }
    else {
      if (client_->connect () != CMLOG_SUCCESS) {
	system_.reportError (CDEV_SEVERITY_SEVERE, deviceName_, this, 
			     "Cannot connect to cmlogClient Daemon\n");
	return CDEV_ERROR;
      }
    }
  }

  if (client_->postData (*out) == CMLOG_SUCCESS)
    status = CDEV_SUCCESS;

  return status;
}

int
cmlogRequestObject::sendNoBlock (cdevData& out, cdevData& result)
{
  return sendNoBlock (&out, &result);
}

int
cmlogRequestObject::sendNoBlock (cdevData* out, cdevData& result)
{
  return sendNoBlock (out, &result);
}

int
cmlogRequestObject::sendNoBlock (cdevData& out, cdevData* result)
{
  return sendNoBlock (&out, result);
}

int
cmlogRequestObject::sendNoBlock (cdevData* out, cdevData* result)
{
  return CDEV_INVALIDARG;
}

int
cmlogRequestObject::sendCallback (cdevData& data, cdevCallback& callback)
{
  return sendCallback (&data, callback);
}

int
cmlogRequestObject::sendCallback (cdevData* data, cdevCallback& userCallback)
{
  return CDEV_INVALIDARG;
}
