//-----------------------------------------------------------------------------
// Copyright (c) 1991,1992 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
// Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
//-----------------------------------------------------------------------------
// 
// Description:
//	CODA Xpm Button X interface
//	
// Author:  Jie Chen
//       CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: XcodaXpmpbtnInterface.h,v $
//   Revision 1.1.1.1  1999/09/07 15:29:08  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:25:38  bickley
// Added cmlog to application development system.
//
//   Revision 1.1.1.1  1996/10/10 19:24:59  chen
//   coda motif C++ library
//
//
#ifndef _X_CODA_XPMBTN_INTERFACE_H
#define _X_CODA_XPMBTN_INTERFACE_H

#include <XcodaPbtnInterface.h>
class XcodaXpm;

class XcodaXpmpbtnInterface: public XcodaPbtnInterface
{
 public: 
  XcodaXpmpbtnInterface (Widget, char **, codaComd *);
  XcodaXpmpbtnInterface (Widget, char **, codaComd *, char *);
  virtual ~XcodaXpmpbtnInterface();
  
  virtual void init();

  virtual const char *className() const {return "XcodaXpmpbtnInterface";}
 private:
  Widget   _parent;
  XcodaXpm *nxpm;
};
#endif
