//-----------------------------------------------------------------------------
// Copyright (c) 1991,1992 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
// Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
//-----------------------------------------------------------------------------
// 
// Description:
//	 CODA Xpm Push Button X Interface
//	
// Author:  Jie Chen
//       CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: XcodaXpmpbtnInterface.cc,v $
//   Revision 1.1.1.1  1999/09/07 15:29:08  chen
//   CMLOG version 2.0
//
// Revision 1.2  1997/09/24  17:49:10  chen
// modify addCallback pointer
//
// Revision 1.1  1997/08/01  15:25:36  bickley
// Added cmlog to application development system.
//
//   Revision 1.1.1.1  1996/10/10 19:24:56  chen
//   coda motif C++ library
//
//
#include <stdio.h>
#include <XcodaXpmpbtnInterface.h>
#include <XcodaXpm.h>
#include <Xm/PushB.h>

XcodaXpmpbtnInterface::XcodaXpmpbtnInterface(Widget parent,
					     char **pix,
					     codaComd *cmd)
:XcodaPbtnInterface (parent, cmd)
{
#ifdef _TRACE_OBJECTS
  printf("Create XcodaXpmpbtnInterface Objects \n");
#endif
  _parent = parent;
  nxpm = new XcodaXpm(parent, pix);
}

XcodaXpmpbtnInterface::XcodaXpmpbtnInterface(Widget parent,
					     char **pix,
					     codaComd *cmd,
					     char *symbol)
:XcodaPbtnInterface (parent, cmd)
{
#ifdef _TRACE_OBJECTS
  printf("Create XcodaXpmpbtnInterface Objects \n");
#endif
  _parent = parent;
  nxpm = new XcodaXpm(parent, pix, symbol);
}

XcodaXpmpbtnInterface::~XcodaXpmpbtnInterface()
{
#ifdef _TARCE_OBJECTS
  printf("Destroy XcodaXpmpbtnInterface Objects \n");
#endif
  delete nxpm;
}

void XcodaXpmpbtnInterface::init ()
{
  Arg           arg[10];
  int           ac = 0;
  Pixmap        npixmap = 0;

  // from XcodaXpm class
  npixmap = nxpm->createPixmapFromXpm();

  if(npixmap){
    XtSetArg (arg[ac], XmNlabelType, XmPIXMAP); ac++;
    XtSetArg (arg[ac], XmNlabelPixmap, npixmap); ac++;
    _w = XtCreateWidget (_name, xmPushButtonWidgetClass, _parent,
			 arg, ac);
    ac = 0;
  }
  else
    _w = XtCreateWidget (_name, xmPushButtonWidgetClass, _parent,
			 NULL, 0);
  installDestroyHandler();

  if(_active)
    activate();
  else
    deactivate();
  
  XtAddCallback (_w,
		 XmNactivateCallback,
		 (XtCallbackProc)&(codaComdXInterface::executeComdCallback),
		 (XtPointer)this);
  XtManageChild (_w);
}
