//-----------------------------------------------------------------------------
// Copyright (c) 1991,1992 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
// Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
//-----------------------------------------------------------------------------
// 
// Description:
//	 Timer Interface to Reactor Class
//	
// Author:  Jie Chen
//       CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: reactorTimer.h,v $
//   Revision 1.1.1.1  1999/09/07 15:29:06  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:22:52  bickley
// Added cmlog to application development system.
//
//
#ifndef _REACTOR_TIMER_H
#define _REACTOR_TIMER_H

#include <ace/Reactor.h>
#include <ace/Event_Handler.h>
#include "reactorTimerRep.h"

class reactorTimer
{
public:
  // single alarm firing in milliseconds
  void arm (unsigned int msec);
  // Auto timer for automatic firing every msec
  void auto_arm (unsigned int msec);
  // auto timer for automatic firing evrty msec after delay of dsec
  void auto_arm (unsigned int msec, unsigned int dsec);
  // Auto timer after tick interval has been set
  void auto_arm (void);
  // is timer auto armed
  int  auto_armed () const;
  // disable an alarm
  void dis_arm ();
  // return time since timer started for auto_timer in seconds
  float elapsedTime();
  // return counter and interval
  void counter (int cnt);
  int  counter (void) const;
  void interval (int val);
  int  interval (void) const;
  // real task will be performed by this routine
#ifndef __vxworks
  virtual void timer_callback () = 0;
#else
  virtual void timer_callback () {}
#endif

  // Destructor
  virtual ~reactorTimer (void);

protected:
  // constructor
  reactorTimer (ACE_Reactor &reactor);

  // normalize msec to sec + msec
  void normalize (unsigned msec, long& sec, long& msecout);

private:
  ACE_Reactor         &reactor_;
  reactorTimerRep      timerRep_;
  int                  autoArmed_;
};
#endif
