// The following configuration is for vxworks
#if !defined (ACE_CONFIG_H)
#define ACE_CONFIG_H

// Platform supports recvmsg and sendmsg.
#define ACE_HAS_MSG

// Platform supports reentrant functions (i.e., all the POSIX *_r functions).
#define ACE_HAS_REENTRANT_FUNCTIONS

// Compiler's template mechanism must see source code (i.e., .C files).
#define ACE_TEMPLATES_REQUIRE_SOURCE

// Compiler doesn't support static data member templates.
#define ACE_LACKS_STATIC_DATA_MEMBER_TEMPLATES

// platform does not support memory sync
#define ACE_LACKS_MSYNC

// platform does not support memory advise
#define ACE_LACKS_MADVISE

// platform does not have memory.h
#define ACE_LACKS_MEMORY_H

// Compiler/platform correctly calls init()/fini() for shared libraries.
#define ACE_HAS_AUTOMATIC_INIT_FINI

// Platform supports POSIX O_NONBLOCK semantics.
#define ACE_HAS_POSIX_NONBLOCK

// Compiler/platform has correctly prototyped header files.
#define ACE_HAS_CPLUSPLUS_HEADERS

// Compiler/platform supports SunOS high resolution timers.
//#define ACE_HAS_HI_RES_TIMER

// Platform supports IP multicast
#define ACE_HAS_IP_MULTICAST

// Platform supports POSIX timers via timestruc_t.
#define ACE_HAS_POSIX_TIME
//#define ACE_HAS_SVR4_TIME

// Compiler/platform defines the sig_atomic_t typedef.
#define ACE_HAS_SIG_ATOMIC_T

// Platform supports SVR4 extended signals.
//#define ACE_HAS_SIGINFO_T

// Compiler supports the ssize_t typedef.
#define ACE_HAS_SSIZE_T

// Platform supports the sigwait
#define ACE_HAS_SIGWAIT

// Platform supports STREAMS.
//#define ACE_HAS_STREAMS

// Platform supports STREAM pipes.
//#define ACE_HAS_STREAM_PIPES

// Compiler/platform supports strerror ().
#define ACE_HAS_STRERROR

// Compiler has system V signals
//#define ACE_HAS_SVR4_SIGNAL_T

// platform has consistant signal protype
#define ACE_HAS_CONSISTENT_SIGNAL_PROTOTYPES

// Compiler/platform supports struct strbuf.
// #define ACE_HAS_STRBUF_T

// Compiler/platform supports SVR4 dynamic linking semantics.
//#define ACE_HAS_SVR4_DYNAMIC_LINKING

// Compiler/platform supports SVR4 gettimeofday() prototype.
//#define ACE_HAS_SVR4_GETTIMEOFDAY


// Platform provides <sys/filio.h> header.
//#define ACE_HAS_SYS_FILIO_H

// Compiler/platform supports sys_siglist array.
//#define ACE_HAS_SYS_SIGLIST

// Defines the page size of the system.
#define ACE_PAGE_SIZE 4096

#endif /* ACE_CONFIG_H */
