/* -*- C++ -*- */

// ============================================================================
//
// = LIBRARY
//    ace
// 
// = FILENAME
//    Str_Buf.h
//
// = AUTHOR
//    Doug Schmidt 
// 
// ============================================================================

#if !defined (ACE_STR_BUF_H)
#define ACE_STR_BUF_H

#include "OS.h"

#if !defined (ACE_HAS_STRBUF_T)
struct strbuf
{
  int   maxlen;                 /* no. of bytes in buffer */
  int   len;                    /* no. of bytes returned */
  void  *buf;                   /* pointer to data */
};
#endif /* ACE_HAS_STRBUF_T */

struct ACE_Str_Buf
  // = TITLE
  //     Simple wrapper for STREAM pipes strbuf.
{
  // = Initialization method
  ACE_Str_Buf (void *b = 0, int l = 0, int max = 0)
    : buf (b), len (l), maxlen (max) 
    { }
  // Constructor.

  int maxlen;                 
  // Number of bytes in buffer.

  int len;                    
  // Number of bytes returned.

  void *buf;              
  // Pointer to data.
};

#endif /* ACE_STR_BUF_H */
