/* -*- C++ -*- */
// Defines the Internet domain address family address format.

#include "ace/Log_Msg.h"

// Return the address.

INLINE void *
ACE_INET_Addr::get_addr (void) const
{
  return (void *) &this->inet_addr_;
}

// Transform the current address into string format.

INLINE int
ACE_INET_Addr::addr_to_string (char s[], size_t) const
{
  // This should check to make sure len is long enough...
  ACE_OS::sprintf (s, "%s:%d", this->get_host_addr (), this->get_port_number ()); 
  return 0;
}

// Return the dotted Internet address.

INLINE const char *
ACE_INET_Addr::get_host_addr (void) const
{
  return ACE_OS::inet_ntoa (this->inet_addr_.sin_addr);  
}

// Return the 4-byte IP address, converting it into host byte order.

INLINE ACE_UINT32
ACE_INET_Addr::get_ip_address (void) const
{
  return ntohl (ACE_UINT32 (this->inet_addr_.sin_addr.s_addr));
}

// Return the port number, converting it into host byte order...

INLINE u_short
ACE_INET_Addr::get_port_number (void) const
{
  return ntohs (this->inet_addr_.sin_port);
}
