/* -*- C++ -*- */
/* Abstract base class for UNIX FIFOs (a.k.a. "named-pipes"). */

#include "ace/Log_Msg.h"

INLINE int 
ACE_FIFO::get_local_addr (const char *&r) const
{
  ACE_TRACE ("ACE_FIFO::get_local_addr");
  r = this->rendezvous_;
  return 0;
}

INLINE int
ACE_FIFO::remove (void)
{
  ACE_TRACE ("ACE_FIFO::remove");
  int result = this->close ();
  return ACE_OS::unlink (this->rendezvous_) == -1 || result == -1 ? -1 : 0;
}

