.\"**********************************************************************
.\"*									*
.\"*	Copyright 1993 by Motorola Wireless Data Group,			*
.\"*			  Bothell, WA					*
.\"*									*
.\"*	Motorola hereby grants permission to use, copy, modify and	*
.\"*	distribute  this software and its documentation for any		*
.\"*	purpose and without fee, provided that you retain this		*
.\"*	copyright notice in all copies.  Motorola makes no		*
.\"*	representations about the suitability of this software for any	*
.\"*	purpose.  Motorola provides this software ``as is'' without	*
.\"*	express or implied warranty.					*
.\"*									*
.\"**********************************************************************
.\"
.\" $Header: /mizar/local/source/coda_source/Tcl/src7.4/svipc/man/sem.n,v 1.1.1.1 1996/08/21 19:30:10 heyes Exp $
.\"
.TH "Tcl_semaphores" TCL "" "Tcl"
.SH NAME
semget, semop, semrmid, semset, semstat, semval - Tcl interface to
semaphore IPC functions.

.SH SYNOPSYS
.nf
\fBsemget \fIkey nsem ?mode? ?create? ?excl?\fR

\fBsemop \fIsemid {semnum sem_op ?undo? ?nowait?}...\fR

\fBsemrmid \fIsemid\fR

\fBsemset \fIsemid {uid gid mode}\fR

\fBsemstat \fIsemid ?varName?\fR

\fBsemval \fIsemid {?semnum? ?val|varName?}...?\fR
.fi

.SH DESCRIPTION
These commands allow access to the System V IPC semaphores from Tcl
applications.  They generally allow the same functionality as the
semop(2), semget(2) and semctl(2) system calls.
'
.SS semget
Create or connect to a semaphore set.  The \fImode\fR optional
parameter sets the semaphore permissions if the semaphore set does not
yet exist.  The \fIcreate\fR and \fIexcl\fR
optional parameters set the IPC_CREAT and IPC_PRIVATE flags in the
semget(2) system call.
'
.SS semop
Perform one or more opeartions on the specified semaphore set.  This
call provides a direct interface to the semop(2) system call.  Each
parameter after the first provides a list of two to four parameters
specifying the operation to perform on the semaphores.  The \fIundo\fR
and \fInowait\fR optional parameters set the SEM_UNDO and IPC_NOWAIT
flags respectively.
'
.SS semrmid
Removes the specified semaphore set by calling semctl(2) with the
IPC_RMID command.
'
.SS semset
Modify the owner, group, or permissions of a semaphore set, by using
the semctl(2) system call with the IPC_SET command.
'
.SS semstat
Return all known status about the semaphore set, placing the returned
status into the named array or returning a structured list value.  If
you pass a variable name, the command places the IPC_STAT values into
the array elements \fBcuid\fR, \fBcgid\fR, \fBuid\fR, \fBgid\fR,
\fBmode\fR, \fBseq\fR, \fBkey\fR,\fBnsems\fR, \fBotime\fR, and \fBctime\fR.
Then, for each semaphore in the set, it creates the elements \fBval\fIn\fR,
\fBpid\fIn\fR, \fBncnt\fIn\fR, and \fBzcnt\fIn\fR containing the
results of the GETVAL, GETPID, GETNCNT and GETZCNT semctl(2) commands.
This command also returns a structured list containing the values:
.sp
.in 0.5i
.nf
{{cuid cgid uid gid mode seq key} nsems otime ctime {val1 pid1 ncnt1 zcnt1}...}
.fi
.in
'
.SS semval
Gets or sets semaphore values.  Specifying only the \fIsemid\fR
returns the value of all semaphores in the list as the command value.
The optional parameters either return the value of a specified
semaphore into a variable or set the semaphore from the numeric value.
'
.SH SEE ALSO
semctl(2), semget(2), semop(2)
.SH AUTHOR
.nf
Joe Kelsey
Motorola Wireless Data Group
19807 NorthCreek Parkway N.
Bothell, WA  98011
206.489.5746
kelsey@mdd.comm.mot.com
