'\" The definitions below are for supplemental macros used in Tix
'\" manual entries.
'\"
'\" .HS name section [date [version]]
'\"	Replacement for .TH in other man pages.  See below for valid
'\"	section names.
'\"
'\" .AP type name in/out [indent]
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS [type [name]]
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .VS
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
.\"
'\"	# Heading for Tix man pages
.de HS
.ds ^3 \\0
.if !"\\$3"" .ds ^3 \\$3
.if '\\$2'cmds'      .TH "\\$1" 1 "\\*(^3" "\\$4" "\\$5"
.if '\\$2'lib'       .TH "\\$1" 3 "\\*(^3" "\\$4" "\\$5"
.if '\\$2'ncmds'     .TH "\\$1" n "\\*(^3" "\\$4" "\\$5"
.if '\\$2'tcl'       .TH "\\$1" n "\\*(^3"  Tcl   "Tcl Built-In Commands"
.if '\\$2'tk'        .TH "\\$1" n "\\*(^3"  Tk    "Tk Commands"
.if '\\$2'tclc'      .TH "\\$1" 3 "\\*(^3"  Tcl   "Tcl Library Procedures"
.if '\\$2'tkc'       .TH "\\$1" 3 "\\*(^3"  Tk    "Tk Library Procedures"
.if '\\$2'tclcmds'   .TH "\\$1" 1 "\\*(^3"  Tcl    "Tcl Applications"
.if '\\$2'tkcmds'    .TH "\\$1" 1 "\\*(^3"  Tk    "Tk Applications"
.if '\\$2'tix'        .TH "\\$1" n "\\*(^3"  Tk    "Tix Commands"
.if '\\$2'tixcmds'    .TH "\\$1" 1 "\\*(^3"  Tk    "Tix Applications"
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'----------------------------------------------------------------------
.HS tixPanedWindow tix 4.0
.BS
'
'
'----------------------------------------------------------------------
.SH NAME
tixPanedWindow \- Create and manipulate tixPanedWindow widgets
'
'----------------------------------------------------------------------
.SH SYNOPSIS
\fBtixPanedWindow\fI \fIpathName ?\fIoptions\fR?
'
'----------------------------------------------------------------------
.SH "STANDARD OPTIONS"
'
The PanedWindow widget supports all the standard options of a frame
widget. See the \fBoptions(n)\fR manual entry for details on the
standard options.
'
'----------------------------------------------------------------------
.SH "WIDGET-SPECIFIC OPTIONS"
'
'----------BEGIN
.LP
.nf
'
Name:		\fBcommand\fR
Class:		\fBCommand\fR
Switch:		\fB\-command\fR
'
.fi
.IP
'
Specifies the command to invoke when the panes change their sizes.
This command is called with a list of integers that record the new
sizes of the panes. The sizes of the panes are listed in the order of
the panes' creation.
'----------END
'
'----------BEGIN
.LP
.nf
'
Name:		\fBhandleActiveBg\fR
Class:		\fBHandleActiveBg\fR
Switch:		\fB\-handleactivebg\fR
'
.fi
.IP
'
Specifies the active background color of the resize handles. When the
mouse cursor enters a resize handle, the resize handle will adopt
the active background color.
'----------END
'
'
'----------BEGIN
.LP
.nf
'
Name:		\fBhandleBg\fR
Class:		\fBBackground\fR
Switch:		\fB\-handlebg\fR
'
.fi
.IP
'
Specifies the normal background color of the resize handles.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBheight\fR
Class:		\fBHeight\fR
Switch:		\fB\-height\fR
.fi
.IP
Specifies the desired height for the window.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBorientation\fR
Class:		\fBOrientation\fR
Switch:		\fB\-orientation\fR
Alias:		\fB\-orient\fR
.fi
.IP
Specifies the orientation of the panes. Must be either \fBvertical\fR
or \fBhorizontal\fR.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBpaneBorderWidth\fR
Class:		\fBPaneBorderWidth\fR
Switch:		\fB\-paneborderwidth\fR
Alias:		\fB\-panebd\fR
.fi
.IP
Specifies the border width of the panes.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBpaneRelief\fR
Class:		\fBPaneRelief\fR
Switch:		\fB\-panerelief\fR
.fi
.IP
Specifies the border relief of the panes.
'----------END
'
'----------BEGIN
.LP
.nf
'
Name:		\fBseparatorActiveBg\fR
Class:		\fBSeparatorActiveBg\fR
Switch:		\fB\-separatoractivebg\fR
'
.fi
.IP
'
Specifies the active background color of the separators. When the user
grabs a resize handle, the separators
will adopt the active background color.
'----------END
'
'----------BEGIN
.LP
.nf
'
Name:		\fBseparatorBg\fR
Class:		\fBBackground\fR
Switch:		\fB\-separatorbg\fR
'
.fi
.IP
'
Specifies the normal background color of the separators.
'----------END
'
'
'----------BEGIN
.LP
.nf
Name:		\fBwidth\fR
Class:		\fBWidth\fR
Switch:		\fB\-width\fR
.fi
.IP
Specifies the desired width for the window.
'----------END
'----------------------------------------------------------------------
.SH SUBWIDGETS
.PP
'
All the pane subwidgets created as a result of the \fBadd\fR command
can be accessed by the \fBsubwidget\fR command. They are identified by
the \fBpaneName\fR parameter to the \fBadd\fR command.
'
.BE
'
'----------------------------------------------------------------------
.SH DESCRIPTION

.PP
'
The \fBtixPanedWindow\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into a PanedWindow widget.
Additional options, described above, may be specified on the command
line or in the option database to configure aspects of the
PanedWindow widget such as its cursor and relief.
'
.PP
'
The PanedWindow widget allows the user to interactively manipulate the
sizes of several panes. The panes can be arranged either vertically or
horizontally. Each individual pane may have upper and lower limits of
its size. The user changes the sizes of the panes by dragging the
resize handle between two panes.
'
'----------------------------------------------------------------------
.SH "WIDGET COMMAND"
'
.PP
'
The \fBtixPanedWindow\fR command creates a new Tcl command whose name is
the same as the path name of the PanedWindow widget's window.  This
command may be used to invoke various operations on the widget.  It
has the following general form:
'
.DS C
'
\fIpathName option \fR?\fIarg arg ...\fR?
.PP
'
.DE
'
\fIPathName\fR is the name of the command, which is the same as the
frame widget's path name. \fIOption\fR and the \fIarg\fRs determine
the exact behavior of the command.  The following commands are
possible for PanedWindow widgets:
'
.TP 
'
\fIpathName \fBadd\fI paneName \fR?\fIoption value ...\fR?
'
Adds a new pane subwidget with the name \fIpaneName\fR into the
PanedWindow widget. Additional configuration options can be
given to configure the new button subwidget. Three configuration
options are supported:
.RS
'
.TP
\fB\-after\fR \fIpane\fR
'
Specifies that the new pane should be placed after \fIpane\fR in the
list of panes in this PanedWindow widget.
'
\fB\-at\fR \fIinteger\fR
'
Specifies the position of the new pane in the list of panes in this
PanedWindow widget. \fB0\fR means the first position, \fB1\fR means
the second, and so on. In addition, \fBend\fR means the end of the
list.
'
.TP
\fB\-before\fR \fIpane\fR
'
Specifies that the new pane should be placed before \fIpane\fR in the
list of panes in this PanedWindow widget.
'
.TP
\fB\-min\fR \fIinteger\fR
'
Specifies the minimum size, in pixels, of the new pane; the default is 0.
'
.TP
\fB\-max\fR \fIinteger\fR
Specifies the maximum size, in pixels, of the new pane; the default is 10000.
'
.TP
\fB\-size\fR \fIinteger\fR
Specifies the size, in pixels, of the new pane; if the \fB\-size\fR
option is not given, or set to the empty string, the PanedWindow
widget will use the natural size of the pane subwidget.
'
.RE
'
.TP
\fIpathName \fBcget\fR \fIoption\fR
'
Returns the current value of the configuration option given by
\fIoption\fR. \fIOption\fR may be \fB\-min\fR, \fB\-max\fR and/or
\fB\-size\fR, or any option accepted by the Tk frame widget.
'
.TP
'
\fIpathName \fBconfigure\fR ?\fIoption\fR? \fI?value option value ...\fR?
'
Query or modify the configuration options of the widget.  If no
\fIoption\fR is specified, returns a list describing all of the
available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s); in
this case the command returns an empty string. \fIOption\fR may be any
of the non-static options of the PanedWindow widget.
'
.TP
\fIpathName \fBdelete\fR \fIpaneName\fR
'
Removes the pane given by \fIpaneName\fR and deletes its contents.
'
.TP
\fIpathName \fBforget\fR \fIpaneName\fR
'
Removes the pane given by \fIpaneName\fR but does not delete its
contents. This pane can be later added back to the PanedWindow widget
by the \fBmanage\fR method.
'
.TP
\fIpathName \fBmanage\fR \fIpaneName \fR?\fIoption value ...\fR?
'
Adds the pane given by \fIpaneName\fR back to the PanedWindow widget.
\fIPaneName\fR must be already forgotten by the \fBforget\fR
method. Additional \fIoption-value\fR pairs, same as those accepted by
the \fBadd\fR method, can be given to control the appearance and
position of the pane.
'
.TP
\fIpathName \fBpanecget\fR \fIpaneName option\fR
'
Returns the current value of the configuration option given by
\fIoption\fR in the pane given by \fIpaneName\fR. \fIOption\fR may
have any of the values accepted by the \fBadd\fR widget command.
'
.TP
'
\fIpathName \fBpaneconfigure\fI paneName ?\fIoption\fR? \fI?value ...\fR?
'
'
When no option is given, prints out the values of all options of this
pane. If \fIoption\fR is specified with no \fIvalue\fR, then the
command returns the current value of that option. If one or more
\fIoption\-value\fR pairs are specified, then the command modifies the
given pane's option(s) to have the given value(s); in this case the
command returns an empty string. \fIOption\fR may be \fB\-min\fR,
\fB\-max\fR and/or \fB\-size\fR, or any option accepted by the Tk
frame widget. The sizes of the panes may be changed as a result of
calling the \fBpaneconfigure\fR command.
'
.TP
\fIpathName \fBpanes\fR
'
Returns a list of the names of all panes.
'
.TP
\fIpathName \fBsubwidget \fI name ?args?\fR 
'
When no options are given, returns the pathname of the subwidget of
the specified name.

When options are given, the widget command of the specified subwidget will
be called with these options.
'
'----------------------------------------------------------------------
.SH BINDINGS
'
The panes' sizes will be changed when the user drags the handles. The
change in the panes' sizes may be subjected to the \fB\-min\fR,
\fB\-max\fR and \fB\-size\fR options of the panes.
'
'
'----------------------------------------------------------------------
.SH KEYWORDS
'
TIX, Container Widget
