'\" The definitions below are for supplemental macros used in Tix
'\" manual entries.
'\"
'\" .HS name section [date [version]]
'\"	Replacement for .TH in other man pages.  See below for valid
'\"	section names.
'\"
'\" .AP type name in/out [indent]
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS [type [name]]
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .VS
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
.\"
'\"	# Heading for Tix man pages
.de HS
.ds ^3 \\0
.if !"\\$3"" .ds ^3 \\$3
.if '\\$2'cmds'      .TH "\\$1" 1 "\\*(^3" "\\$4" "\\$5"
.if '\\$2'lib'       .TH "\\$1" 3 "\\*(^3" "\\$4" "\\$5"
.if '\\$2'ncmds'     .TH "\\$1" n "\\*(^3" "\\$4" "\\$5"
.if '\\$2'tcl'       .TH "\\$1" n "\\*(^3"  Tcl   "Tcl Built-In Commands"
.if '\\$2'tk'        .TH "\\$1" n "\\*(^3"  Tk    "Tk Commands"
.if '\\$2'tclc'      .TH "\\$1" 3 "\\*(^3"  Tcl   "Tcl Library Procedures"
.if '\\$2'tkc'       .TH "\\$1" 3 "\\*(^3"  Tk    "Tk Library Procedures"
.if '\\$2'tclcmds'   .TH "\\$1" 1 "\\*(^3"  Tcl    "Tcl Applications"
.if '\\$2'tkcmds'    .TH "\\$1" 1 "\\*(^3"  Tk    "Tk Applications"
.if '\\$2'tix'        .TH "\\$1" n "\\*(^3"  Tk    "Tix Commands"
.if '\\$2'tixcmds'    .TH "\\$1" 1 "\\*(^3"  Tk    "Tix Applications"
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'----------------------------------------------------------------------
.HS tixDirList tix 4.0
.BS
'
'
'----------------------------------------------------------------------
.SH NAME
tixDirList \- Create and manipulate tixDirList widgets
'
'
'
'----------------------------------------------------------------------
.SH SYNOPSIS
\fBtixDirList\fI \fIpathName ?\fIoptions\fR?
'
'
'----------------------------------------------------------------------
.PP
.SH SUPER-CLASS
The \fBTixDirList\fR class is derived from the \fBTixScrolledHList\fR
class and inherits all the commands, options and subwidgets of its
super-class.
'
'----------------------------------------------------------------------
.SH "STANDARD OPTIONS"
'
\fBTixDirList\fR supports all the standard options of a frame widget.
See the \fBoptions(n)\fR manual entry for details on the standard options.
'
'
'----------------------------------------------------------------------
.SH "WIDGET-SPECIFIC OPTIONS"
'
'----------BEGIN
.LP
.nf
Name:		\fBbrowseCmd\fR
Class:		\fBBrowseCmd\fR
Switch:		\fB\-browsecmd\fR
.fi
.IP
Specifies a command to call whenever the user browses on a directory
(usually by single-clicking on the name of the directory). The command
is called with one argument, the complete pathname of the directory.
'----------END
'
'
'----------BEGIN
.LP
.nf
Name:		\fBcommand\fR
Class:		\fBCommand\fR
Switch:		\fB\-command\fR
.fi
.IP
Specifies the command to be called when the user activates on a directory
(usually by double-clicking on the name of the directory). The command
is called with one argument, the complete pathname of the directory.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBdircmd\fR
Class:		\fBDirCmd\fR
Switch:		\fB\-dircmd\fR
.fi
.IP
Specifies the TCL command to be called when a directory listing is
needed for a particular directory. If this option is not specified, by
default the DirList widget will attempt to read the directory as a
Unix directory. On special occasions, the application programmer may
want to supply a special method for reading directories: for example,
when he needs to list remote directories. In this case, the
\fB\-dircmd\fR option can be used. The specified command accepts two
arguments: the first is the name of the directory to be listed; the
second is a Boolean value indicating whether hidden sub-directories
should be listed. This command returns a list of names of the
sub-directories of this directory. For example:
\fC
.nf

 proc read_dir {dir show_hidden} {
     if {$dir == "C:\\"} {
         return {DOS NORTON WINDOWS}
     } else {
         return {}
     }
 }
.fi
\fR
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBdisableCallback\fR
Class:		\fBDisableCallback\fR
Switch:		\fB\-disablecallback\fR
.fi
.IP
A boolean value indicating whether callbacks should be disabled. When
set to true, the TCL command specified by the \fB\-command\fR option
is not executed when the \fB\-value\fR of the DirList widget
changes.
'----------END
'
'----------BEGIN
'
.LP
.nf
Name:		\fBshowHidden\fR
Class:		\fBShowHidden\fR
Switch:		\fB\-showhidden\fR
.fi
.IP
Specifies whether hidden directories should be shown. By default, a
directory name starting with a period "." is considered as a hidden
directory. This rule can be overridden by supplying an alternative
\fB\-dircmd\fR option.
'----------END
'
'----------END
'
.LP
.nf
Name:		\fBroot\fR
Class:		\fBRoot\fR
Switch:		\fB\-root\fR
.fi
.IP
'
Specifies the name of the root directory. Usually this is \fB"/"\fR
under Unix machines, but can be changed to \fB"C:\\"\fR in DOS environments.
'----------END
'
'----------END
'
.LP
.nf
Name:		\fBrootName\fR
Class:		\fBRootNAme\fR
Switch:		\fB\-rootname\fR
.fi
.IP
'
Specifies a text string to display at the root directory. If
unspecified, the text string will be the same as the string specified
by \fB\-root\fR.
'----------END
'
'----------END
'
.LP
.nf
Name:		\fBvalue\fR
Class:		\fBValue\fR
Switch:		\fB\-value\fR
Alias:		\fB\-directory\fR
.fi
.IP
Specifies the name of the current directory to be displayed in the
DirList widget.
'----------END
'
'----------------------------------------------------------------------
.SH SUBWIDGETS
'----------BEGIN
.LP
.nf
Name:		\fBhlist\fR
Class:		\fBTixHList\fR
.fi
.IP
The hierarchical listbox that displays the directory listing.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBhsb\fR
Class:		\fBScrollbar\fR
.fi
.IP
The horizontal scrollbar subwidget.
'----------END
'
'
'----------BEGIN
.LP
.nf
Name:		\fBvsb\fR
Class:		\fBScrollbar\fR
.fi
.IP
The vertical scrollbar subwidget.
'----------END
'
.BE
'
'
'----------------------------------------------------------------------
.SH DESCRIPTION
'
.PP
'
The \fBtixDirList\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into a DirList widget.
Additional options, described above, may be specified on the command
line or in the option database to configure aspects of the
DirList such as its cursor and relief.

The DirList widget displays a list view of a directory, its
previous directories and its sub-directories. The user can choose one
of the directories displayed in the list or change to another
directory.
'
'
'----------------------------------------------------------------------
.SH WIDGET COMMANDS
.PP
'
The \fBtixDirList\fR command creates a new Tcl command whose name is
the same as the path name of the DirList's window.  This
command may be used to invoke various operations on the widget. It has
the following general form:
'
.DS C
'
\fIpathName option \fR?\fIarg arg ...\fR?
.PP
.DE
'
\fIPathName\fR is the name of the command, which is the same as the
DirList widget's path name. \fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command. The following commands
are possible for DirList widgets:
'
.TP
\fIpathName \fBcget\fR \fIoption\fR
'
Returns the current value of the configuration option given by
\fIoption\fR. \fIOption\fR may have any of the values accepted by the
\fBtixDirList\fR command.
'
.TP
\fIpathName \fBchdir\fR \fIdir\fR
'
Change the current directory to \fIdir\fR.
'
'
.TP
'
\fIpathName \fBconfigure\fR ?\fIoption\fR? \fI?value option value ...\fR?
'
Query or modify the configuration options of the widget.  If no
\fIoption\fR is specified, returns a list describing all of the
available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s); in
this case the command returns an empty string.  \fIOption\fR may have
any of the values accepted by the \fBtixDirList\fR command.
'
'
.TP
\fIpathName \fBsubwidget \fI name ?args?\fR 
'
When no options are given, this command returns the pathname of the
subwidget of the specified name.

When options are given, the widget command of the specified subwidget
will be called with these options.
'
'
'
'----------------------------------------------------------------------
.SH BINDINGS
.PP
'
The mouse and keyboard bindings of the DirList widget is the same as
the bindings of the HList widget.
'
'
'----------------------------------------------------------------------
.SH KEYWORDS
Tix(n)
