'\" The definitions below are for supplemental macros used in Tix
'\" manual entries.
'\"
'\" .HS name section [date [version]]
'\"	Replacement for .TH in other man pages.  See below for valid
'\"	section names.
'\"
'\" .AP type name in/out [indent]
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS [type [name]]
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .VS
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
.\"
'\"	# Heading for Tix man pages
.de HS
.ds ^3 \\0
.if !"\\$3"" .ds ^3 \\$3
.if '\\$2'cmds'      .TH "\\$1" 1 "\\*(^3" "\\$4" "\\$5"
.if '\\$2'lib'       .TH "\\$1" 3 "\\*(^3" "\\$4" "\\$5"
.if '\\$2'ncmds'     .TH "\\$1" n "\\*(^3" "\\$4" "\\$5"
.if '\\$2'tcl'       .TH "\\$1" n "\\*(^3"  Tcl   "Tcl Built-In Commands"
.if '\\$2'tk'        .TH "\\$1" n "\\*(^3"  Tk    "Tk Commands"
.if '\\$2'tclc'      .TH "\\$1" 3 "\\*(^3"  Tcl   "Tcl Library Procedures"
.if '\\$2'tkc'       .TH "\\$1" 3 "\\*(^3"  Tk    "Tk Library Procedures"
.if '\\$2'tclcmds'   .TH "\\$1" 1 "\\*(^3"  Tcl    "Tcl Applications"
.if '\\$2'tkcmds'    .TH "\\$1" 1 "\\*(^3"  Tk    "Tk Applications"
.if '\\$2'tix'        .TH "\\$1" n "\\*(^3"  Tk    "Tix Commands"
.if '\\$2'tixcmds'    .TH "\\$1" 1 "\\*(^3"  Tk    "Tix Applications"
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'----------------------------------------------------------------------
.HS tixItemType tix 4.0
.BS
'
'
'----------------------------------------------------------------------
.SH NAME
Tix Display Items
'
.BE
'
.SH DESCRIPTION
'
The Tix \fBDisplay Items\fR and \fBDisplay Types\fR are devised to
solve a general problem: many Tix widgets (both existing and planned
ones) display many items of many types simutaneously.
'
.PP
'
For example, a hierarchical listbox widget (HList) can display items
of images, plain text and subwindows in the form of a
hierarchy. Another widget, the tabular listbox, (TList, currently
planned and will be released in Tix 4.1) also display items of the
same types, although it arranges the items in a tabular form. Yet
another widget, the spreadsheet widget, also displays similar types
items, but in yet another format.
'
.PP
'
In these examples, the display items in different widgets are only
different in how they are arranged by the \fBhost widget\fR. In Tix,
display items are clearly separated from the host widgets. The
advantage is two-fold: first, the creation and configuration of
display items become uniform across different host widgets. Second,
new display item types can be added without the need to modify the
existing host widgets.
'
.PP
'
In a way, Tix display items are similar to the items inside Tk
the canvas widget. However, unlike the Tix display items, the canvas
items are not independent of the canvas widget; this makes it
impossible to use the canvas items inside other types of TK widgets.
'
.PP
'
The appearance of a display item is controlled by a set of
\fIattributes\fR. It is observed that each the attributes usually fall
into one of two categroies: "\fIindividual\fR" or
"\fIcollective\fR". For example, the text items inside a HList widget
may all display a different text string; however, in most cases, the
text items share the same color, font and spacing. Instead of keeping
a duplicated version of the same attributes inside each display item,
it will be advantageous to put the collective attributes in a
special object called a \fBdisplay style\fR. First, there is the space
concern: a host widget may have many thousands of items; keeping
dupilcated attributes will be very wasteful. Second, when it becomes
necessary to change a collective attribute, such as changing all the
text items' foreground color to red, it will be more efficient to
change only the display style object than to modify all the text
items one by one.
'
.PP
'
The attributes of the a display item are thus stored in two places: it
has a set of \fBitem options\fR to store its individual attributes. Each
display item is also associated with a \fIdisplay style\fR, which specifies
the collective attributes of all items associated with itself.
'
.PP
'
The division between the individual and collective attributes are
fixed and cannot be changed. Thus, when it becomes necessary for some
items to differ in their collective attributes, two or more \fBdisplay
styles\fR can be used. For example, suppose you want to display two
columns of text items inside an HList widget, one column in red and
the other in blue. You can create a TextStyle object called "red",
which defines a red foreground, and another called "blue", which
defines a blue foreground. You can then associate all text items of
the first column to "red" and the second column to "blue".
'
.SH DISPLAY ITEM TYPES AND OPTIONS
'
Currently there are three types of display items: \fBtext\fR,
\fBimagetext\fR and \fBwindow\fR. 
'
'----------------------------------------------------------------------
'			ImageText
'----------------------------------------------------------------------
.SH IMAGETEXT ITEMS
'
Display items of the type \fBimagetext\fR are used to display an image
together with a text string. Imagetext items support the following options:
'
.PP
\fBITEM OPTIONS\fR
.PP
.RS
'----------BEGIN
.LP
.nf
Name:		\fBbitmap\fR
Class:		\fBBitmap\fR
Switch:		\fB\-bitmap\fR
.fi
.IP
Specifies the bitmap to display in the item.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBimage\fR
Class:		\fBImage\fR
Switch:		\fB\-image\fR
.fi
.IP
Specifies the image to display in the item. When both the
\fB\-bitmap\fR and \fB\-image\fR options are specified, only the image
will be displayed.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBimageTextStyle\fR
Class:		\fBImageTextStyle\fR
Switch:		\fB\-style\fR
.fi
.IP
Specifies the display style to use for this item. Must be the
name of a \fBimagetext\fR display style that has already be created by
the \fBtixDisplayStyle(n)\fR command.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBshowImage\fR
Class:		\fBShowImage\fR
Switch:		\fB\-showimage\fR
.fi
.IP
A Boolean value that specifies whether the image/bitmap should be
displayed.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBshowText\fR
Class:		\fBShowText\fR
Switch:		\fB\-showtext\fR
.fi
.IP
A Boolean value that specifies whether the text string should be
displayed.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBtext\fR
Class:		\fBText\fR
Switch:		\fB\-text\fR
.fi
.IP
Specifies the text string to display in the item.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBunderline\fR
Class:		\fBUnderline\fR
Switch:		\fB\-underline\fR
.fi
.IP
Specifies the integer index of a character to underline in the text
string in the item.  0 corresponds to the first character of the text
displayed in the widget, 1 to the next character, and so on.
'----------END
.RE
'
.PP
\fBSTYLE OPTIONS\fR
'
.PP
The style information of \fBimagetext\fR items are stored in the
\fBimagetext\fR display style. The following options are supported:
'
.RS
'
.PP
\fBSTANDARD OPTIONS\fR
'
.PP
\fC
.ta 6c
.nf
activeBackground	activeForeground
anchor			background
disabledBackground	disabledForeground
foreground		font
justify			padX
padY			selectBackground
selectForeground	wrapLength
.fi
\fR
.ta 4c 
.PP
See the \fBoptions(n)\fR manual entry for details on the standard
options.
.PP
'
.PP
\fBSTYLE-SPECIFIC OPTIONS\fR
.PP
'----------BEGIN
.LP
.nf
Name:		\fBgap\fR
Class:		\fBGap\fR
Switch:		\fB\-gap\fR
'
.fi
.IP
Specifies the distance between the bitmap/image and the text string,
in number of pixels.
'----------END
'
.RE
'
'**********************************************************************
'
'			text
'
'**********************************************************************
.SH TEXT ITEMS
'
Display items of the type \fBtext\fR are used to display a text string
in a widget. Text items support the following options:
'
.PP
\fBITEM OPTIONS\fR
.PP
.RS
'----------BEGIN
.LP
.nf
Name:		\fBtextStyle\fR
Class:		\fBTextStyle\fR
Switch:		\fB\-style\fR
.fi
.IP
Specifies the display style to use for this text item. Must be the
name of a \fBtext\fR display style that has already be created by the
\fBtixDisplayStyle(n)\fR command.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBtext\fR
Class:		\fBText\fR
Switch:		\fB\-text\fR
.fi
.IP
Specifies the text string to display in the item.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBunderline\fR
Class:		\fBUnderline\fR
Switch:		\fB\-underline\fR
.fi
.IP
Specifies the integer index of a character to underline in the item.
0 corresponds to the first character of the text displayed in the
widget, 1 to the next character, and so on.
'----------END
.RE
'
\fBSTYLE OPTIONS\fR
.PP
.RS
.PP
\fBSTANDARD OPTIONS\fR
'
.PP
\fC
.ta 6c
.nf
activeBackground	activeForeground
anchor			background
disabledBackground	disabledForeground
foreground		font
justify			padX
padY			selectBackground
selectForeground	wrapLength
.fi
\fR
.ta 4c 
.PP
See the \fBoptions(n)\fR manual entry for details on the standard
options.
'
'
.PP
.RE
'**********************************************************************
'
'			Window
'
'**********************************************************************
.SH WINDOW ITEMS
'
Display items of the type \fBwindow\fR are used to display a
sub-window in a widget. \fBWindow\fR items support the following
options:
'
.PP
\fBITEM OPTIONS\fR
.PP
.RS
'----------BEGIN
.LP
.nf
Name:		\fBwindowStyle\fR
Class:		\fBWindowStyle\fR
Switch:		\fB\-style\fR
.fi
.IP
Specifies the display style to use for this window item. Must be the
name of a \fBwindow\fR display style that has already be created by
the \fBtixDisplayStyle(n)\fR command.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBwindow\fR
Class:		\fBWindow\fR
Switch:		\fB\-window\fR
Alias:		\fB\-widget\fR
.fi
.IP
Specifies the sub-window to display in the item.
'----------END
'
.RE
'
\fBSTYLE OPTIONS\fR
.PP
.RS
\fBSTANDARD OPTIONS\fR
'
.PP
\fC
.ta 6c
.nf
anchor
padX		padY
.PP
.fi
.ta 4c
See the \fBoptions(n)\fR manual entry for details on the standard
options.
'
.PP
.RE
'
'**********************************************************************
'
.SH CREATING DISPLAY ITEMS
'
'
Display items do not exist on their and thus they cannot be created
independently of the widgets they reside in. As a rule, display items
are created by special widget commands of their "host" widgets. For
example, the HList widgets has a command \fBitem\fR which can be used
to create new display items. The following code creates a new imagetext
item at the third column of the entry foo inside an HList widget:
'
.PP
\fC
.nf
 tixHList .h -columns 3
 .h add foo
 .h item create foo 2 \-itemtype imagetext \-text Hello \-image image1
.fi
.PP
\fR
'
The \fBitem create\fR command of the HList widget accepts a variable
number of arguments. The special argument \fB\-itemtype\fR specifies
which type of display item to create. Options that are valid for this
type of display items can then be specified by one or more
\fIoption\-value\fR pairs.
'
.PP
'
After the display item is created, they can then be configured or
destroyed using the commands provided by the host widget. For example,
the HList widget has the command \fBitem configure\fR, \fBitem cget\fR
and \fBitem delete\fR for accessing the display items.
'
'**********************************************************************
'
.SH CREATING AND MANIPULATING DISPLAY STYLES
'
'
Display styles are created by the command \fBtixDisplayStyle\fR:
'
.SH SYNOPSIS
\fBtixDisplayStyle\fI \fIitemType\fR ?\fI\-stylename name\fR? ?\fI\-refwindow pathName\fR? ?\fIoptions value ...\fR?
'
'
.PP
\fIitemType\fR must be one of the existing display items types such as
\fBtext\fR, \fBimagetext\fR, \fBwindow\fR or any new types added by
the user. Additional arguments can be given in one or more
\fIoption\-value\fR pairs. \fIoption\fR can be any of the valid option
for this display style or any of the following:
.PP
.RS
'
.TP
\fB\-stylename \fIname\fR
'
Specifies a name for this style. If unspecified, then a default name
will be chosen for this style.
'
.TP
\fB\-refwindow \fIpathName\fR
'
Specifies a window to use for determine the default values of the
display type. If unspecified, the main window will be used. Default
values for the display types can be set via the options database. The
following example sets the \fB\-disablebackground\fR and
\fB\-disabledforeground\fR options of a \fBtext\fR display style via
the option database:
\fC
.nf
option add *table.list*disabledForeground blue
option add *table.list*disabledBackground darkgray
tixDisplayStyle text -refwindow .table.list -fg red
.fi
\fR
'
By using the option database to set the options of the display styles,
we can advoid hard-coding the option values and give the user more
flexibility in customization. See option(n) for a detailed description
of the option database.
'
.SH STYLE COMMAND
.PP
The \fBtixDisplayStyle\fR command creates a new Tcl command whose name is the
same as the name of the newly created display style.  This command
may be used to invoke various operations on the display style.  It has the
following general form:
'
'
.DS C
'
\fIstyleName option \fR?\fIarg arg ...\fR?
.PP
.DE
'
\fIstyleName\fR is the name of the command. \fIOption\fR and the
\fIarg\fRs determine the exact behavior of the command. The following
commands are possible:
'
.TP
\fIstyleName \fBcget\fR \fIoption\fR
'
Returns the current value of the configuration option given by
\fIoption\fR. \fIOption\fR may have any of the valid options of this
display style.
'
.TP
'
\fIstyleName \fBconfigure\fR ?\fIoption\fR? \fI?value option value ...\fR?
'
Query or modify the configuration options of the display style.  If no
\fIoption\fR is specified, returns a list describing all of the
available options for \fIstyleName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list). If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given option(s) to have the given value(s); in this case
the command returns an empty string. \fIOption\fR may have any of the
valid options of this display style.
'
.TP
\fIstyleName \fBdelete\fR
'
Destroy this display style object.
'
.SH EXAMPLE
'
The following example creates two columns of data in a HList
widget. The first column is in red and the second column in blue. The
colors of the columns are controlled by two different \fBtext\fR
styles. Also, the anchor and font of the second column is chosen so
that the income data is aligned properly.
'
.PP
\fC
.nf
set courier -*-courier-medium-r-*-*-14-*-*-*-*-*-*-*
tixHList .h -columns 2; pack .h
set red  [tixDisplayStyle text -fg #800000]
set blue [tixDisplayStyle text -fg #000080 -anchor e -font $courier]

foreach n {{Joe $10,000} {Peter $20,000} {Raj $90,000} {Zinh $0}} {
    set entry [.h addchild {}]
    .h item create $entry 0 -itemtype text \\
	-text [lindex $n 0] -style $red
    .h item create $entry 1 -itemtype text \\
	-text [lindex $n 1] -style $blue
}
.fi
.PP
\fR

