#!/bin/sh
#\
exec $CODA_BIN/dpwish -notk -f "$0" ${1+"$@"}
#
# valid fifo modes are: all,request and conditional
# valid wait modes are: sleep and async
# prescale is 1 for every event 10 for every tenth event etc...

dds_create

ddu_init INPUT all 1 sleep

ddu_start

struct_typedef fev {struct
    {int shmid}
    {int dboff}
    {int p2da}
    {int len}
    {int ctlw1}
    {int ctlb1}
    {int ctlw2}
    {int ctlb2}
}

struct_typedef ev_buf {struct
    {ulong len}
    {ulong*0 data}
}

global nevents 

set nevents 0

proc get_event {} {
    global nevents

    set addr [ ddu_req_fev 10000 ]

    struct_new fifoev fev fev@$addr 

    struct_new buf ev_buf ev_buf@$fifoev(p2da)

    set buf(len) 123

    set header [expr 0x00001000 | ($nevents & 0xff)]

    incr nevents

    set buf(data.0) $header 
    puts "$addr -> len [set buf(len)], data(0)=[format "%08x" [set buf(data.0)]]"

    unset fifoev
    unset buf

    ddu_put_fev $addr
}

puts "type anything when ready to start"
gets stdin
puts "starting"
 
while {[ddu_attached]} {
    get_event
    dp_after 400
}