//---------------------------------------------------------------------------
// Copyright (c) 1995      Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//----------------------------------------------------------------------------
//
// description: equal.h
//	This file provides a method for comparing 2 floating point numbers 
//	and determining if they are reasonably equivalent.
//
// Author: Walt Akers
//
// Revision History:
//   equal.h,v
// Revision 1.1  1995/09/22  18:36:26  akers
// Added comparison function for floats and doubles
//
// Revision 1.1  1995/09/01  18:15:51  akers
// Initial installation of the Compound Device Service
//
//
//--------------------------------------------------------------------------
#ifndef _EQUAL_H_
#define _EQUAL_H_ 1

#include <float.h>

inline double Fabs(double a)  { return ((a)<0.0?-(a):(a)); }
inline double Max (double a, double b) { return (a>b)?a:b; }	
static int equal(double a, double b)
	{
	return (Fabs((a-b)/((a+b)==0.0?Max(Fabs(a),1E-300):(a+b)))<=FLT_EPSILON);
	}

#endif /* _EQUAL_H_ */
