#include <cdevSystem.h>
#include <cdevDevice.h>
#include <cdevData.h>
#include <stdio.h>

int main()
{
  cdevDevice *dir = cdevDevice::attachPtr("cdevDirectory");
  cdevData input, output;

  cdevData::insertTag(0x1001, "PV");
  
  // ***********************************************************
  // * Insert the name of the device and message to be resolved.
  // ***********************************************************
  input.insert("device", "diag1");
  input.insert("message", "get value");

  // ***********************************************************
  // * Submit the request to the cdevDirectory object using the
  // * send command, and output the result (using asciiDump) if
  // * successful.
  // ***********************************************************
  if(dir->send("serviceData", input, output)==CDEV_SUCCESS)
  {    
    output.asciiDump(stdout);
  } else {
    fprintf(stderr, "Send Failed\n");
  }
}

