#include <cdevData.h>

class myDataCallback : public cdevTagTableCallback
{
private:
	char * name_;

public:
	myDataCallback ( char * name )
		{
		name_ = strdup(name);
                cdevData::addTagCallback(this);
		}
	~myDataCallback ( void )
		{
		cdevData::delTagCallback(this);
                free(name_);
		}
	void callback (int newTag, char * newName)
		{
		fprintf(stdout, "%s: Tag %i was just assigned to name \"%s\"\n", name_, newTag, newName);
		}
};

int main()
{
char ** names = NULL;
int * tags = NULL;
int cnt = 0;
int i;

cdevData::readTagTable (tags, names, cnt);
for(i=0; i<cnt; i++)
	{
	fprintf(stdout, "%-26.26s = %i\n", names[i], tags[i]);
	}
delete names;
delete tags;

myDataCallback cb1("Callback1"), cb2("Callback2"), * cb3 = new myDataCallback("Callback3"), cb4("Callback4");

char string1[24];

for(i=100; i<110; i++)
	{
	sprintf(string1, "TAG%i", i);
	cdevData::insertTag(i, string1);
	cdevData::insertTag(i, string1);
	}
delete cb3;
for(i=110; i<120; i++)
	{
	sprintf(string1, "TAG%i", i);
	cdevData::insertTag(i, string1);
	cdevData::insertTag(i, string1);
	}
}
