#include <cdevDirectoryTool.h>

int main ( int argc, char ** argv )
	{
	int    result     = 0;
	char * inputFile  = NULL;
	char * outputFile = NULL;	
	FILE * fp         = NULL;
	
	for(int i=1; i<argc; i++)
		{
		if(!strcmp(argv[i], "-o")) outputFile = argv[++i];
		else                       inputFile = argv[i];
		}
	
	if(inputFile==NULL || outputFile==NULL)
		{
		cdevSystem::defaultSystem().reportError
			(CDEV_SEVERITY_ERROR, "CDEV DDL Un-Compiler", NULL,
			 "\n  => Bad or missing arguments\n  => Format is: uncompile inputFile -o outputFile");
		result = -1;
		}
	else if((fp = fopen(outputFile, "w"))==NULL)
		{
		cdevSystem::defaultSystem().reportError
			(CDEV_SEVERITY_ERROR, "CDEV DDL Un-Compiler", NULL,
			"Could not open output file %s", outputFile);
		result = -1;
		}	
	else	{
		cdevDirectoryTable table;

		fprintf(stdout, "uncompile: Converting %s to %s\n", inputFile, outputFile);
		fflush (stdout);
		if(table.load (inputFile)==CDEV_SUCCESS) table.asciiDump(fp);
		fclose(fp);
		}

	return result;
	}
