/*
 * Definitions etc. for regexp(3) routines.
 *
 * Caveat:  this is V8 regexp(3) [actually, a reimplementation thereof],
 * not the System V one.
 */

#ifndef _CDEV_REGEXP_H
#define _CDEV_REGEXP_H
/* The following is copied directly from <X11/Xos.h> */

#ifndef X_NOT_STDC_ENV
#include <string.h>
#ifndef index
#define index strchr
#endif
#ifndef rindex
#define rindex strrchr
#endif

#else

#ifdef SYSV
#include <string.h>
#define index strchr
#define rindex strrchr
#else
#include <strings.h>
#define strchr index
#define strrchr rindex
#endif

#endif /* X_NOT_STDC_ENV */

#define NSUBEXP  10
typedef struct regexp {
	char *startp[NSUBEXP];
	char *endp[NSUBEXP];
	char regstart;		/* Internal use only. */
	char reganch;		/* Internal use only. */
	char *regmust;		/* Internal use only. */
	int regmlen;		/* Internal use only. */
	char program[1];	/* Unwarranted chumminess with compiler. */
} regexp;

#ifdef __cplusplus
extern "C" {
#endif

#if defined (__STDC__) || defined (__cplusplus)
extern regexp *regcomp(char* exp);
extern int regexec(register regexp* prog, register char* string);
extern void regsub(regexp* prog, char* source, char* dest);
extern void regerror(char* s);
#else
extern regexp *regcomp();
extern int regexec();
extern void regsub();
extern void regerror();
#endif

#ifdef __cplusplus
};
#endif

#endif
