//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      cdevRequestObject for cdevDirectory Class
//
// Author:  Jie Chen
//
// Revision History:
//   cdevDirRequestObj.h,v
// Revision 1.1  1998/02/13  14:01:45  chen
// enable request object for cdevDirectory
//
//
#ifndef _CDEV_DIR_REQUEST_OBJ_H
#define _CDEV_DIR_REQUEST_OBJ_H

#include <cdevSystem.h>
#include <cdevDevice.h>
#include <cdevRequestObject.h>

class CDEV_CLASS_SPEC cdevDirRequestObj: public cdevRequestObject
{
public:
  // constructor and destructor
  cdevDirRequestObj  (cdevDevice& device, char* msg,
		      cdevSystem& system = cdevSystem::defaultSystem ());
  
  ~cdevDirRequestObj (void);

  int send (cdevData& out, cdevData& result);
  int send (cdevData *out, cdevData& result);
  int send (cdevData& out, cdevData* result);
  int send (cdevData *out, cdevData* result);


  int sendNoBlock (cdevData& out, cdevData& result);
  int sendNoBlock (cdevData* out, cdevData& result);
  int sendNoBlock (cdevData& out, cdevData* result);
  int sendNoBlock (cdevData* out, cdevData* result);

  int sendCallback (cdevData& out, cdevCallback& callback);
  int sendCallback (cdevData* out, cdevCallback& callback);

  const char *className (void) const {return "cdevDirRequestObj";}
};
#endif

  
