//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      cdevClock class implementation
//
// Author:  Jie Chen
//
// Revision History:
//   cdevClock.cc,v
// Revision 1.2  1998/02/10  18:04:56  chen
// add cdevSystem timer handler
//
// Revision 1.1.1.1  1995/06/16  17:14:01  epics
// initial import of cdev
//
//
#include "cdevClock.h"

const cdevTimeValue cdevClock::zero;

cdevClock::cdevClock (void): clock_value_ (), usr_arg_ (0)
{
#ifdef _TRACE_OBJECTS
  printf("Create cdevClock class\n");
#endif
}

cdevClock::~cdevClock (void)
{
#ifdef _TRACE_OBJECTS
  printf("Delete cdevClock class\n");
#endif
}

int 
cdevClock::isEmpty (void) const
{
  return clock_value_ == cdevClock::zero;
}

const cdevTimeValue &
cdevClock::scheduledTime (void) const
{
  return clock_value_;
}

cdevTimeValue
cdevClock::currentTime (void)
{
  cdevTimeValue     tv;

#ifdef _WIN32
  _timeb cur_time;
  _ftime (&cur_time);
#else
  timeval cur_time;
  ::gettimeofday (&cur_time, 0);
#endif
  tv.set (cur_time);
  return tv;
}

int
cdevClock::schedule (const void *arg,
		     const cdevTimeValue &future_time)
{
  clock_value_ = future_time + cdevClock::currentTime();
  usr_arg_ = arg;
  return 0;
}

int
cdevClock::cancel (void)
{
  clock_value_ = cdevClock::zero;
  return 0;
}

int
cdevClock::expired (void)
{
  if (cdevClock::currentTime() >= clock_value_)
    return 1;
  else
    return 0;
}
