/* -----------------------------------------------------------------------------
 * Copyright (c) 1994,1995 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * -----------------------------------------------------------------------------
 *
 * defCallbackCollector : This class is used to collect the callbacks from a
 *                        a single cdevDefCollectionRequest.  This is an 
 *                        implementation class that is only associated with the
 *                        default cdevCollectionObject if the developer's 
 *                        service does not provide specific support for 
 *                        collections.
 *
 *                        The cdevCollectionRequest object will obtain the 
 *                        cdevData object from this object and will return it
 *                        to the caller or to an interim 
 *                        cdevGrpCollectionRequest object.
 *
 * Author:  Walt Akers
 *
 * Revision History:
 *   defCallbackCollector.h,v
 * Revision 1.1  1996/11/12  20:32:37  akers
 * New collection device source code
 *
 * -----------------------------------------------------------------------------
 */

#ifndef _DEF_CALLBACK_COLLECTOR_H_
#define _DEF_CALLBACK_COLLECTOR_H_

#include <cdevData.h>
#include <cdevTranObj.h>
#include <cdevCollectionRequest.h>

class defCallbackCollector
{
public:
	typedef struct
		{
		int                    index;
		int                    processed;
		defCallbackCollector * parent;
		} Request;

	int           counter;
	cdevData      result;
	cdevData    & format;
	cdevTranObj * xobj;
	Request     * requests;
	int           nRequests;
	
	defCallbackCollector   ( int NRequests, cdevData &Format, cdevTranObj &XObj );
	~defCallbackCollector  ( void );
	int           finished          ( void );
	void          processRequest    ( int idx, int status, cdevData *data = NULL );
	void          mergeData         ( cdevData &to, cdevData &from, size_t size, int idx);
	cdevDataTypes resolveTargetType ( cdevDataTypes to, cdevDataTypes from );
	void          copyItemToArray   ( cdevData &to, cdevData &from, int tag, int idx);
	void          installEmptyArray ( cdevData &data, int tag, cdevDataTypes type, size_t size, size_t arraySize = 1);
	void          resizeArray       ( cdevData &data, int tag, cdevDataTypes type, size_t size, size_t arraySize = 1);
};

#endif /* _DEF_CALLBACK_COLLECTOR_H_ */	
