/* -----------------------------------------------------------------------------
 *  Copyright (c) 1994,1995 Southeastern Universities Research Association,
 *                          Continuous Electron Beam Accelerator Facility
 * 
 *  This software was developed under a United States Government license
 *  described in the NOTICE file included as part of this distribution.
 * 
 * -----------------------------------------------------------------------------
 * 
 *  Description:
 *       cdevCollection class implementation
 * 
 *  Author:  Walt Akers, Chip Watson & Jie Chen
 * 
 *  Revision History:
 *    cdevCollection.h,v
 * Revision 1.3  1998/08/03  16:24:25  chen
 * AIX porting
 *
 * Revision 1.2  1997/12/12  16:35:43  chen
 * add VMS fix
 *
 * Revision 1.1  1996/11/12  20:32:11  akers
 * New collection device source code
 *
 * -----------------------------------------------------------------------------
 */ 

#ifndef _CDEV_COLLECTION_H
#define _CDEV_COLLECTION_H

#include <cdevSpec.h>
#include <cdevDevice.h>

#if defined(__VMS) || defined (AIX)
typedef char* va_list;
#undef va_start
#define va_start(ap,v) ((void)((ap)=(char*)(&v + 1)))
#undef va_arg
#define va_arg(ap,type) (((type *)((ap)+=sizeof(type)))[-1])
#undef va_end
#define va_end(ap) ((void)0)
#endif

class cdevCollectionRequest;

class CDEV_CLASS_SPEC cdevCollection: public cdevDevice
{
 friend class cdevDevice;

 public:
  //===================================================================
  //     Public Interface for Clients
  //===================================================================
  static cdevCollection& attachRef (char *name);
  static cdevCollection* attachPtr (char *name);
  // PURPOSE: create a reference or pointer for device of a given name
  //          within the default system
  // REQUIRE: name != 0
  // PROMISE: a cdevCollection 

  static void detach (cdevCollection& dev);
  static void detach (cdevCollection* dev);
  // PURPOSE: destroy a cdevCollection
  // REQUIRE: dev != 0
  // PROMISE: memory will be freed if no more attachment on this device

  //========================================================================
  //     Public Interface for cdevRequestObject
  //========================================================================
  virtual cdevRequestObject *getRequestObject (char * msg );
  virtual int getRequestObject (char *msg, cdevRequestObject* &reqobj);
  // PURPOSE: get right requestObject based on its name
  // REQUIRE: name != 0, callers provide pointer only.
  // PROMISE: always return CDEV_SUCCESS. reqobj may be an errorRequestObject

  //========================================================================
  //     Public Interface for RTTI
  //========================================================================
  virtual const char *className (void) const {return "cdevCollection";}

  //========================================================================
  //     Public Interface for list manipulation
  //========================================================================
  char ** getList();
  // PURPOSE: obtain a null terminated array of device names
  // REQUIRE: caller is responsible for freeing list
  // PROMISE: if collection is empty, returns NULL

  int add(char* name);			// add a single device
  int add(int num, char* name, ...);	// add multiple devices
  int add(int num, char** names);	// add array of names of length num
  int add(char** names);	       	// add a null terminated array of names
  int addRegexp(char* regexp);		// add by regular expression
  int remove(char* name);
  int remove(int num, char* name, ...);
  int remove(int num, char** names);
  int remove(char** names);	       	// remove a null terminated array of names
  int removeRegexp(char* regexp);
  // PURPOSE: add(remove) a (list of/regexp of) names to the collection
  // REQUIRE: nothing
  // PROMISE: merged list will have no duplicates
  //          return CDEV_SUCCESS: no duplicates/missing found, CDEV_WARNING:
  //          at least one duplicate name was dropped during add or
  //          at least one name was not found during remove

 protected:
  //constructors and destructor
  cdevCollection (char *name,
		  cdevSystem& system = cdevSystem::defaultSystem() );
  virtual ~cdevCollection (void);

  // attach pointer or reference with system as second argument
  static cdevCollection& attachRef (char *name, cdevSystem& system);
  static cdevCollection* attachPtr (char *name, cdevSystem& system);
  // PURPOSE: create a reference or pointer for device of a given name
  // REQUIRE: name != 0
  // PROMISE: a cdevCollection 

 private:
  cdevSlist nameList_;

  // hide assignment and copy operator since the collection is
  // a memory manager for collectionRequests and lists of devices
  cdevCollection& operator = (const cdevCollection &);
  cdevCollection (const cdevCollection &);

  // friend class declaration
  friend class cdevCollectionRequest;
};
#endif




