//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      Channel Access Name Service (Used when there is no DDL file)
//      Accessed by caService Only
//
// Author:  Jie Chen
//
// Revision History:
//   caNameSvc.h,v
// Revision 1.3  1997/08/27  18:16:59  chen
// fix compile warning
//
// Revision 1.2  1995/07/05  18:31:48  chen
// minor changes
//
// Revision 1.1.1.1  1995/06/16  17:14:03  epics
// initial import of cdev
//
//
#ifndef _CDEV_CANAME_SVC_H
#define _CDEV_CANAME_SVC_H

#include <stdio.h>
#include <assert.h>
#include <cdevSystem.h>
#include <cdevDevice.h>
#include <cdevData.h>
#include <cdevCallback.h>
#include <cdevDirectory.h>

class caNameSvc: public cdevDevice
{
 public:
  // constructor and destructor
  caNameSvc (cdevSystem& system = cdevSystem::defaultSystem());
  ~caNameSvc (void);

  int send (char *msg, cdevData& data, cdevData &result);
  int send (char *msg, cdevData* data, cdevData &result);
  int send (char *msg, cdevData& data, cdevData *result);
  int send (char *msg, cdevData* data, cdevData *result);
  // PURPOSE: find service data 
  // REQUIRE: msg must be "resolveServiceData deviceName message [attr]
  // RPOMISE: service data will be returned from result as deviceName.attr

  const char *className (void) const {return "caNameSvc";}

 protected:
  // hide all those unnecessary member functions
  int sendNoBlock (char *msg, cdevData& out, cdevData& result);
  int sendNoBlock (char *msg, cdevData* out, cdevData& result);
  int sendNoBlock (char *msg, cdevData& out, cdevData* result);
  int sendNoBlock (char *msg, cdevData* out, cdevData* result);

  int sendCallback (char *msg, cdevData& out, cdevCallback& callback);
  int sendCallback (char *msg, cdevData* out, cdevCallback& callback);

  int getRequestObject  (char *msg, cdevRequestObject* &reqobj);
  cdevRequestObject* getRequestObject (char *msg);

  int registerReqObject (cdevRequestObject *obj);
  int removeReqObject   (cdevRequestObject *obj);
  
 private:
  // deny access to copy and assignment operations since there will be
  // only one caNameSvc
  caNameSvc (const caNameSvc& );
  caNameSvc& operator = (const caNameSvc& );
};
#endif
  
