//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      Channel Access Name Service
//      This will be used when there is no DDL file presented
//
// Author:  Jie Chen
//
// Revision History:
//   caNameSvc.cc,v
// Revision 1.6  1997/08/27  18:16:58  chen
// fix compile warning
//
// Revision 1.5  1997/05/30  19:10:42  chen
// cosmatic touch
//
// Revision 1.4  1997/03/25  22:24:33  akers
// Development in support of a new cdevDirectory
//
// Revision 1.3  1996/01/05  18:39:36  chen
// Fix a potential bug for gcc
//
// Revision 1.2  1995/07/05  18:31:54  chen
// minor changes
//
// Revision 1.1.1.1  1995/06/16  17:14:02  epics
// initial import of cdev
//
//
#include <ctype.h>
#include <cdevErrCode.h>
#include "caService.h"
#include "caNameSvc.h"

caNameSvc::caNameSvc(cdevSystem &system)
:cdevDevice((char *)"caNameService", system)
{
#ifdef _TRACE_OBJECTS
  printf("    Create caNameSvc class object\n");
#endif
  system.nameServer().addNameSvc(this);
}

caNameSvc::~caNameSvc(void)
{
#ifdef _TRACE_OBJECTS
  printf("    Delete caNameSvc class object\n");
#endif
  // no need to delete from the directory list
  // system_.nameServer().removeNameSvc (this);
}

// return service data in the form of "dvcName.attribute"
int
caNameSvc::send(char *msg, cdevData*, cdevData *result)
{
  int  errCode = CDEV_SUCCESS;
  char token[64], deviceName[64], message[256], attr[64];
  char svcData[128];
  
#ifdef __GNUC__
  char buffer[400];
  ::strncpy(buffer, msg, sizeof(buffer));
  int status=sscanf(buffer, "%s %s %s", token, deviceName, message);
#else  
  int status=sscanf(msg, "%s %s %s", token, deviceName, message);
#endif
  
  if(status < 3) errCode = CDEV_INVALIDARG;
  else if(::strcmp(token, "resolveServiceData") == 0)
    {
      // check svc data
#ifdef __GNUC__
      status=sscanf(buffer, "%s %s %s %s", token, deviceName, message, attr);
#else
      status=sscanf(msg, "%s %s %s %s", token, deviceName, message, attr);
#endif
      if(status < 4)
	::strcpy(attr, "VAL");
      sprintf(svcData, "%s.%s", deviceName, attr);
      if(result->insert(caService::CA_TAG_PV, svcData) != CDEV_SUCCESS)
	{
	  errCode = CDEV_ERROR;
	}
    }
  else if(::strcmp(token, "resolveService") == 0)
    {
#ifdef __GNUC__
      status=sscanf(buffer, "%s %s %s %s", token, deviceName, message, attr);
#else
      status=sscanf(msg, "%s %s %s %s", token, deviceName, message, attr);
#endif
      if(status < 4)
	::strcpy(attr, "VAL");

      system_.reportError
	(CDEV_SEVERITY_WARN, "CDEV Directory", 0, 
	 "No service matches \"%s\" - \"%s %s\", default to caService",
	 deviceName, message, attr);
      if(result->insert((char *)"value", (char *)"caService") != CDEV_SUCCESS)
	{
	  errCode = CDEV_ERROR;
	}
    }
  else errCode = CDEV_NOTFOUND;

  return errCode;
}

int
caNameSvc::send(char *msg, cdevData &out, cdevData &result)
{
  return send(msg, &out, &result);
}

int
caNameSvc::send(char *msg, cdevData &out, cdevData *result)
{
  return send(msg, &out, result);
}

int
caNameSvc::send(char *msg, cdevData *out, cdevData &result)
{
  return send(msg, out, &result);
}

int
caNameSvc::sendNoBlock(char*, cdevData&, cdevData &)
{
  return CDEV_ERROR;
}

int
caNameSvc::sendNoBlock(char*, cdevData*, cdevData &)
{
  return CDEV_ERROR;
}

int
caNameSvc::sendNoBlock(char*, cdevData&, cdevData *)
{
  return CDEV_ERROR;
}

int
caNameSvc::sendNoBlock(char*, cdevData*, cdevData *)
{
  return CDEV_ERROR;
}

int
caNameSvc::sendCallback(char*, cdevData&, cdevCallback &)
{
  return CDEV_ERROR;
}

int
caNameSvc::sendCallback(char*, cdevData*, cdevCallback &)
{
  return CDEV_ERROR;
}

int
caNameSvc::getRequestObject(char*, cdevRequestObject* &reqobj)
{
  reqobj=0;
  return CDEV_ERROR;
}

cdevRequestObject *
caNameSvc::getRequestObject(char *)
{
  return 0;
}

int
caNameSvc::registerReqObject(cdevRequestObject *)
{
  return CDEV_ERROR;
}

int
caNameSvc::removeReqObject(cdevRequestObject *)
{
  return CDEV_ERROR;
}
