//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//       cdevSystemBase class (abstract class)
//
// Author:  Jie Chen & Chip Watson
//
// Revision History:
//   cdevSystemBase.h,v
// Revision 1.2  1996/05/28  13:00:12  chen
// minor changes
//
// Revision 1.1.1.1  1995/06/16  17:14:08  epics
// initial import of cdev
//
//
#ifndef _CDEV_SYSTEM_BASE
#define _CDEV_SYSTEM_BASE

#include "cdevError.h"
#include "cdevSync.h"

class CDEV_CLASS_SPEC cdevSystemBase: public cdevSync, public cdevError
{
 public:
  virtual ~cdevSystemBase (void);
  // PURPOSE: destructor for cdevSystemBase
  // REQUIRE: nothing
  // PROMISE: it will be gone
  
  virtual char *name (void) const = 0;
  // PURPOSE: pure virtual function
  // REQUIRE: derived class provides real implementation
  // PROMISE: nothing
  
  virtual int getRequestObject (char *deviceName, 
				char *msg, 
				cdevRequestObject* &req) = 0;
  // PURPOSE: pure virtual function
  // REQUIRE: callers provide pointer to cdevRequestObject only, no memory
  // PROMISE: nothing
  virtual const char *className (void) const {return "cdevSystemBase";}

 protected:
  //constructor, deny direct instantiation
  cdevSystemBase (void);
};
#endif

