/*-----------------------------------------------------------------------------
 * Copyright (c) 1994,1995 Southeastern Universities Research Association,
 *               Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 *-----------------------------------------------------------------------------
 *
 * Description:
 *      Cdev and API Specification
 *
 *      Every class header file and C interface header should include
 *      this header
 *
 * Authors:  Jie Chen
 *
 * Revision History:
 *   $Log: cdevSpec.h,v $
 *   Revision 1.2  1999/01/15 17:30:20  akers
 *   Adjustment
 *
 *   Revision 1.1  1999/01/14 17:21:24  chen
 *   CDEV Class and API Spec Class for WIN32
 *
 *
 */
#ifndef _CDEV_SPEC_H
#define _CDEV_SPEC_H

#if defined (_WIN32)

#if !defined (DLLIMPORT)
#define DLLIMPORT __declspec(dllimport)
#endif

#if !defined (DLLEXPORT)
#define DLLEXPORT __declspec(dllexport)
#endif

#if defined (_CDEV_CORE_EXPORTS_) 
#define CDEVAPI DLLEXPORT
#define CDEV_CLASS_SPEC DLLEXPORT
#define CDEVSVC_CLASS_SPEC
#define CDEVSVCAPI
#elif defined (_CDEV_BUILD_SVC)
#define CDEVAPI DLLIMPORT
#define CDEV_CLASS_SPEC DLLIMPORT
#define CDEVSVC_CLASS_SPEC DLLEXPORT
#define CDEVSVCAPI DLLEXPORT
#else
#define CDEVAPI DLLIMPORT
#define CDEV_CLASS_SPEC DLLIMPORT
#define CDEVSVC_CLASS_SPEC
#define CDEVSVCAPI
#endif

#else /* WIN32 */

#define CDEVAPI
#define DLLIMPORT
#define DLLEXPORT
#define CDEV_CLASS_SPEC
#define CDEVSVC_CLASS_SPEC
#define CDEVSVCAPI

#endif

#endif

