//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      cdev Monitoring Object class (for service developer only)
//
//      This class is for services that support monitoring capabilities.
//      It is very much like transanaction object but without being registered
//      in the groups. The transaction objects will be deleted after the first
//      callbacks. The monitor objects will stay around as long as the monitors
//      are on.
//
//      Service developers may have to derive from this class to handle
//      service specific monitoring
//
// Author:  Jie Chen
//
// Revision History:
//   cdevMonitorObj.h,v
// Revision 1.4  1998/02/06  15:29:08  chen
// cosmatic change
//
// Revision 1.3  1998/01/30  14:25:18  akers
// Ongoing development
//
// Revision 1.2  1998/01/30  13:49:19  akers
// Ongoing development
//
// Revision 1.1  1998/01/14  14:26:39  chen
// add cdevMonitorObj
//
//
//
#ifndef _CDEV_MONITOR_OBJ_H
#define _CDEV_MONITOR_OBJ_H

#include <cdevTranObj.h>

class cdevMonitorObj
{
public:
  // constructor and destructor
  cdevMonitorObj(cdevTranObj &tranObj):system_(tranObj.system_), 
  reqObj_(tranObj.reqObj_), resultData_(tranObj.resultData_), 
  userCallback_(tranObj.userCallback_), tobj_(&tranObj)
    {
#ifdef _TRACE_OBJECTS
      printf("Create cdevMonitorObj Class Object\n");
#endif
      // disable transaction from deleting the callback
      tobj_->disableDeleteCbk();
    }
	
  virtual ~cdevMonitorObj(void)
    {
#ifdef _TRACE_OBJECTS
      printf("Delete cdevMonitorObj Class Object\n");
#endif
      if(userCallback_ != 0)
	{
#ifdef _CMLOG_DEBUG
	  printf("Delete userCallback inside cdevMonitorObj\n");
#endif
	  delete userCallback_;
	}
      userCallback_=0;
    }
	
  virtual const char *className(void) const {return"cdevMonitorObj";}

  // data area for requestObject to access
  cdevSystem *system_;
  cdevRequestObject *reqObj_;
  cdevData *resultData_;
  cdevCallback *userCallback_;

  // pointer to transaction object
  cdevTranObj *tobj_;
	
private:
  // deny access to copy and assignment
  cdevMonitorObj(const cdevMonitorObj &);
  cdevMonitorObj &operator=(const cdevMonitorObj &);
};

#endif
