//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//       cdevIOcontext header
//
// Author:  Jie Chen & Chip Watson
//
// Revision History:
//   cdevIOcontext.h,v
// Revision 1.1.1.1  1995/06/16  17:14:06  epics
// initial import of cdev
//
//
#ifndef _CDEV_IO_CONTEXT_H
#define _CDEV_IO_CONTEXT_H

#include <stdio.h>
#include <string.h>
#include <cdevSpec.h>
#include <cdevData.h>

class CDEV_CLASS_SPEC cdevIOcontext
{
 public:
  // constructors and destructor
  virtual ~cdevIOcontext (void);

  cdevData&   getContext (void);
  // PURPOSE: get context represented by a cdevData

  virtual int setContext (cdevData& ctx);
  // PURPOSE: set context from a cdevData
  //          derived class may provide different setContext function
  //          eg. channel access requestObject will use this function
  //          to provide right request data type
  // REQUIRE: nothing
  // PROMISE: return 0
  
  void      setPrivate (void *userdata);
  // PURPOSE: set user provided data
  // REQUIRE: nothing. user handle memory management of userdata
  // PROMISE: user data will not be freeed when this is destroyed

  void *    getPrivate (void);
  // PURPOSE: get user provided data
  // REQUIRE: nothing
  // PROMISE: something

  virtual const char *className(void) const {return "cdevIOcontext";}

 protected:
  // constructor, to prevent from direct instantiation
  cdevIOcontext (void);
  cdevData      data_;
  void          *userData_;
};
#endif

