/* -----------------------------------------------------------------------------
 *  Copyright (c) 1994,1995 Southeastern Universities Research Association,
 *                          Continuous Electron Beam Accelerator Facility
 * 
 *  This software was developed under a United States Government license
 *  described in the NOTICE file included as part of this distribution.
 * 
 * -----------------------------------------------------------------------------
 * 
 *  Description:
 *       cdevErrorCollection class implementation
 * 
 *  Author:  Walt Akers, Chip Watson & Jie Chen
 * 
 *  Revision History:
 *    cdevErrorCollection.h,v
 * Revision 1.1  1996/11/12  20:32:30  akers
 * New collection device source code
 *
 * -----------------------------------------------------------------------------
 */ 

#ifndef _CDEV_ERRORCOLLECTION_H
#define _CDEV_ERRORCOLLECTION_H

#include <cdevCollection.h>

class cdevErrReqObject;

class CDEV_CLASS_SPEC cdevErrorCollection: public cdevCollection
{
 public:
  //========================================================================
  //     Public Interface for cdevRequestObject
  //========================================================================
  virtual cdevRequestObject *getRequestObject (char * msg );
  virtual int getRequestObject (char *msg, cdevRequestObject* &reqobj);
  // PURPOSE: get a requestObject 
  // REQUIRE: name != 0, callers provide pointer only.
  // PROMISE: always return CDEV_INVALIDOBJ

  //========================================================================
  //     Public Interface for RTTI
  //========================================================================
  virtual const char *className (void) const {return "cdevErrorCollection";}

  //========================================================================
  //     Public Interface for list manipulation
  //========================================================================
  int add(char* name, ...);
  int add(char** list, int len);
  int addRegexp(char* regexp);
  int remove(char* name, ...);
  int remove(char** list, int len);
  int removeRegexp(char* regexp);
  // PURPOSE: add(remove) a (list of/regexp of) names to the collection
  // REQUIRE: nothing
  // PROMISE: always return CDEV_INVALIDOBJ

 protected:
  //constructors and destructor
  //constructors will initialize list from directory service
  cdevErrorCollection (char *name);
  ~cdevErrorCollection (void);

 private:
  // hide assignment and copy operator since the collection is
  // a memory manager for collectionRequests and lists of devices
  cdevErrorCollection& operator = (const cdevCollection &);
  cdevErrorCollection (const cdevCollection &);

  // friend class declaration
  friend class cdevCollection;
};
#endif
