//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      cdevClock Class Header File.
//
// Author:  Jie Chen
//
// Revision History:
//   cdevClock.h,v
// Revision 1.2  1998/02/10  18:04:56  chen
// add cdevSystem timer handler
//
// Revision 1.1.1.1  1995/06/16  17:14:02  epics
// initial import of cdev
//
//
#ifndef _CDEV_CLOCK_H
#define _CDEV_CLOCK_H

#include <stdio.h>
#include <string.h>
#include <assert.h>

#include <cdevTimeValue.h>

class CDEV_CLASS_SPEC cdevClock
{
 public: 
  // constructor and destructor
  cdevClock  (void);
  virtual ~cdevClock(void);

  int 			     isEmpty (void) const;
  // PURPOSE: check whether this clock is set or not
  // REQUIRE: nothing
  // PROMISE: return 1: empty, return 0: not empty

  const cdevTimeValue        &scheduledTime (void) const;
  // PURPOSE: return scheduled timer value
  // REQUIRE: nothing
  // PROMISE: return time_value ZERO if empty

  static cdevTimeValue currentTime (void);
  // PURPOSE: return current time
  // REQUIRE: static function
  // PROMISE: return current time (unix only)

  int schedule (const void *a, const cdevTimeValue &);
  // PURPOSE: schedule a timer
  // REQUIRE: nothing
  // PROMISE: your timer will be remembered

  int cancel   (void);
  // PURPOSE: cancel a shceduled timer
  // REQUIRE: nothing
  // PROMISE: there will be no timer

  int expired  (void);
  // PURPOSE: check whether the timer is expired or not
  // REQUIRE: nothing
  // PROMISE: return 1: expired, return 0: not expired

 protected:
  static const cdevTimeValue zero;

 private:
  cdevTimeValue clock_value_;
  const void    *usr_arg_;
  // deny access to copy and assignment operation
  // no reason to create two clocks with same time value
  cdevClock             (const cdevClock&);
  cdevClock& operator = (const cdevClock&);
};
#endif
