#ifndef _CDEV_ALIAS_DEFINITION_H_
#define _CDEV_ALIAS_DEFINITION_H_

#ifndef _CDEV_DIRECTORY_TABLE_H_
	#error "You must include cdevDirectoryTable.h to load cdevAliasDefinition.h"
#endif

#include <stdio.h>

// *****************************************************************************
// * class cdevAliasDefinition :
// *	This class stores the name of an alias and a reference to the device
// *	definition that it is associated with.
// *
// *	This class maintains a variety of internal data items for the following
// *	purposes...
// *
// *	alias   - This is the name of the alias.
// *	device  - This is the cdevDeviceDefinition for the device that it
// *	          references.
// *	next	- This is the next alias in the list.
// *****************************************************************************
class cdevAliasDefinition
{
private:
	char                 * name;
	cdevDeviceDefinition & device;
	cdevAliasDefinition  * next;

public:
	inline cdevAliasDefinition  ( char * Name, cdevDeviceDefinition & Device );
	inline ~cdevAliasDefinition ( void );	
	inline void asciiDump       ( FILE * fp = stdout );

	// *********************************************************************
	// * Member access methods.
	// *********************************************************************
	inline char                 * getName   ( void );
	inline cdevDeviceDefinition & getDevice ( void );
	inline cdevAliasDefinition  * getNext   ( void );
	inline void                   setNext   ( cdevAliasDefinition * Next );

};



// *****************************************************************************
// * cdevAliasDefinition::cdevAliasDefinition :
// *	This is the constructor for the cdevAliasDefinition class.  The Name
// *	pointer becomes the property of the class and should not be accessed
// *	by the caller after it has been provided to this constructor.
// *****************************************************************************
inline cdevAliasDefinition::cdevAliasDefinition 
	( char * Name, cdevDeviceDefinition & Device )
	: name(Name), device(Device), next(NULL)
	{
	}
	

// *****************************************************************************
// * cdevAliasDefinition::~cdevAliasDefinition :
// *	This is the destructor faor the cdevAliasDefinition class.
// *****************************************************************************
inline cdevAliasDefinition::~cdevAliasDefinition ( void )
	{
	delete name;
	}

// *****************************************************************************
// * cdevAliasDefinition::~cdevAliasDefinition :
// *	This is the destructor for the cdevAliasDefinition class.
// *****************************************************************************
inline void cdevAliasDefinition::asciiDump ( FILE * fp )
	{
	fprintf(fp, "alias %s %s\n", name, device.getName());
	}


// *****************************************************************************
// * cdevAliasDefinition::getName :
// *	This method allows the caller to obtain the name of the alias.
// *****************************************************************************
inline char * cdevAliasDefinition::getName ( void )
	{
	return name;
	}
	
// *****************************************************************************
// * cdevAliasDefinition::getDevice :
// *	This method allows the caller to retrieve the device definition 
// *	associated with the object.
// *****************************************************************************
inline cdevDeviceDefinition & cdevAliasDefinition::getDevice ( void )
	{
	return device;
	}
	
// *****************************************************************************
// * cdevAliasDefinition::getNext :
// *	This method allows the caller to get the next alias in the list.
// *****************************************************************************
inline cdevAliasDefinition * cdevAliasDefinition::getNext ( void )
	{
	return next;
	}
	
// *****************************************************************************
// * cdevAliasDefinition::setNext :
// *	This method allows the caller to set the next alias in the list.
// *****************************************************************************
inline void cdevAliasDefinition::setNext ( cdevAliasDefinition * Next )
	{
	next = Next;
	}


#endif /* _CDEV_ALIAS_DEFINITION_H_ */
