#include <MonitorTestService.h>

// *****************************************************************************
// * newMonitorTestService:
// *	This function will be called by the cdevSystem object to create an 
// *	initial instance of the MonitorTestService.
// *****************************************************************************
extern "C" cdevService * newMonitorTestService (char * name, cdevSystem * system)
	{
	return new MonitorTestService(name, *system);
	}

// *****************************************************************************
// * MonitorTestService::MonitorTestService :
// *	This is teh constructor for the MonitorTestService.  It initializes the
// *	underlying cdevClientService by specifying that it is in the domain of
// *	VIRTUAL.
// *****************************************************************************
MonitorTestService::MonitorTestService ( char * name, cdevSystem & system)
	: cdevClientService("MONITOR_TEST", name, system) 
	{
	// *********************************************************************
	// * Install the RESULT_CODE_TAG at a location of 30 or higher if it 
	// * does not already exist.
	// *********************************************************************
	RESULT_CODE_TAG = 0;
	cdevData::tagC2I("resultCode", &RESULT_CODE_TAG);

	for(int i=30; RESULT_CODE_TAG==0 && i<65534; i++)
		{
		cdevData::insertTag(i, "resultCode");
		cdevData::tagC2I("resultCode", &RESULT_CODE_TAG);
		}
				
	system.reportError(CDEV_SEVERITY_INFO, "MonitorTestService", NULL, 
			   "Constructing a new MonitorTestService"); 
	
	}

// *****************************************************************************
// * MonitorTestService::fireCallback :
// *	This is the method that will be called to dispatch the callback methods
// *	that are associated with the calls to the MonitorTest Server.  If the 
// *	message has been processed successfully, then the method will remove
// *	the resultCode from the outbound data and use that as the status.
// *****************************************************************************
void MonitorTestService::fireCallback  ( int status, cdevTranObj &xobj,  cdevData *resultData, int partialTransaction )
	{
	// *********************************************************************
	// * If the message was transmitted successfully, get the result code
	// * from the data that was returned and use that as the status.
	// *********************************************************************
	if(status==CDEV_SUCCESS && resultData!=NULL)
		{
		resultData->get(RESULT_CODE_TAG, &status);
		resultData->remove(RESULT_CODE_TAG);
		}

	cdevClientService::fireCallback(status, xobj, resultData, partialTransaction);
	}
