#include <cdevPlatforms.h>
#include <cdevSystem.h>
#include <cdevRequestObject.h>
#include <cdevDevice.h>
#include <cdevGroup.h>
#include <cdevCommon.h>

int callbackCount = 0;

void callback ( int status, void * /*arg*/, cdevRequestObject & req, cdevData & /*data*/ )
	{
	if(status==CDEV_SUCCESS)
		{
		callbackCount++;
		if(callbackCount%1000==0) fprintf(stdout, "Received callback %i - %s:%s \n", callbackCount, req.device().name(), req.message());
		}
	else if(status==CDEV_DISCONNECTED) fprintf(stdout, "The monitor has become disconnected on %s:%s\n", req.device().name(), req.message());
	else if(status==CDEV_RECONNECTED) fprintf(stdout, "The monitor has become reconnected on %s:%s\n", req.device().name(), req.message());
	else fprintf(stdout, "Status code %i was received on %s:%s\n", req.device().name(), req.message());
	fflush(stdout);
	}
	
const int DEVICE_COUNT  = 9;
const int MESSAGE_COUNT = 9;

int main (  )
	{
	fprintf(stdout, "\n\
=> **********************************************************************\n\
=> * This is is the receiving part of a two part application. This      *\n\
=> * program willl post monitors and will listen for changes that are   *\n\
=> * generated by the other application - MonitorWriter                 *\n\
=> **********************************************************************\n\n");
	cdevDevice * deviceList[DEVICE_COUNT];
	cdevCallback cb(callback, NULL);
	cdevData     data;
	char         msg[255];
	int          deviceCnt;
	int          msgCnt;
	
	cdevRequestObject & req = cdevRequestObject::attachRef("device0", "set default");
	data.insert("value", "MonitorTestServer");
	req.send(data, NULL);
	
	for(deviceCnt=0; deviceCnt<DEVICE_COUNT; deviceCnt++)
		{
		sprintf(msg, "device%i", deviceCnt);
		deviceList[deviceCnt] = cdevDevice::attachPtr(msg);
		
		for(msgCnt=0; msgCnt<MESSAGE_COUNT; msgCnt++)
			{
			sprintf(msg, "monitorOn attrib%i", msgCnt);
			deviceList[deviceCnt]->sendCallback(msg, NULL, cb);
			}
		}
	cdevSystem::defaultSystem().setThreshold(CDEV_SEVERITY_INFO);
	while(1) cdevSystem::defaultSystem().pend(5.0);
	
	return 0;
	}
