//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      RSVC UDP Service Handler (For managed servers only)
//
// Author:  Jie Chen
//
//
//
#ifndef _RSVC_UDP_HANDLER_H
#define _RSVC_UDP_HANDLER_H

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <signal.h>

#include <rsvcDataStoreTable.h>
#include <rsvcConfig.h>

#include <cdevAddr.h>
#include <cdevSocketDatagram.h>
#include <cdevReactor.h>


class rsvcUdpHandler : public cdevEventHandler
{
public:
  // constructor and destructor
  
  // constructor a UDP handler
  rsvcUdpHandler                  (char* dbasename, cdevReactor& r,
				   rsvcDataStoreTable& st);
  // destructor
  ~rsvcUdpHandler                 (void);

  // open the listener of the udp
  int open                        (unsigned short port, int async = 0);

  // return port number
  unsigned short port_number      (void);

protected:
  // inherited operations
  int getHandle                  (void) const;
  int handleClose                (void);
  int handleInput                (void);

private:
  // data area
  cdevReactor&                    reactor_;
  cdevSocketDatagram              listener_;

  // data conversion buffer
  char                            ibuffer_[RSVC_UDP_BUFFER_SIZE];
  // data storage index table
  rsvcDataStoreTable&             storeTable_;
  // database this udp to update to
  char*                           dbasename_;
};
#endif
