//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      Abstract class for network streamable class
//
// Author:  Jie Chen
//
//
//
#ifndef _RSVC_STREAMABLE_H
#define _RSVC_STREAMABLE_H

#include <stdio.h>
#include <rsvcErr.h>

class rsvcStreamable
{
public:
  // virtual destrcutor
  virtual ~rsvcStreamable   (void);
  // return stream size
  virtual size_t streamSize (void) = 0;

  // stream data object out into a newly allocated buffer
  virtual int    streamOut  (char** buffer, size_t* size) = 0;

  // stream data object out into a preallocated buffer
  virtual int    streamOut  (char* buffer, size_t len) = 0;
  
  // recreate data from incoming data buffer
  virtual int    streamIn   (char* buffer, size_t len) = 0;

protected:
  rsvcStreamable            (void);
};
#endif
