/*-----------------------------------------------------------------------------
 * Copyright (c) 1994,1995 Southeastern Universities Research Association,
 *               Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 *-----------------------------------------------------------------------------
 *
 * Description:
 *      RSVC and API Specification
 *
 *      Every class header file and C interface header should include
 *      this header
 *
 * Authors:  Jie Chen
 *
 * Revision History:
 *   $Log: rsvcSpec.h,v $
 *   Revision 1.1  1999/03/15 16:40:09  chen
 *   New file
 *
 *
 */
#ifndef _RSVC_SPEC_H
#define _RSVC_SPEC_H

#if defined (_WIN32)

#if !defined (DLLIMPORT)
#define DLLIMPORT __declspec(dllimport)
#endif

#if !defined (DLLEXPORT)
#define DLLEXPORT __declspec(dllexport)
#endif

#if defined (_RSVC_CORE_EXPORTS_) 
#define RSVCAPI DLLEXPORT
#define RSVC_CLASS_SPEC DLLEXPORT
#elif defined (_RSVC_BUILD_EXE)
#define RSVCAPI
#define RSVC_CLASS_SPEC
#else
#define RSVCAPI DLLIMPORT
#define RSVC_CLASS_SPEC DLLIMPORT
#endif

#else /* WIN32 */

#define RSVCAPI
#define DLLIMPORT
#define DLLEXPORT
#define RSVC_CLASS_SPEC

#endif

#endif

