/*
//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      RSVC error codes
//
// Author:  Jie Chen
//
//
//
*/
#ifndef _RSVC_ERROR_CODE_H
#define _RSVC_ERROR_CODE_H

/* Error and status values                                                 */
#define RSVC_WARNING       -2  /* Failure of function is non-consequential */
#define RSVC_ERROR         -1  /* Errors that are not in any categories    */
#define RSVC_SUCCESS        0  /* RSVC success                             */
#define RSVC_INVALIDOBJ     1  /* invalid RSVC objects                     */
#define RSVC_INVALIDARG     2  /* invalid argument passed to RSVC calls    */
#define RSVC_INVALIDSVC     3  /* wrong service during dynamic loading     */
#define RSVC_INVALIDOP      4  /* operation is unsupported (collection)    */

#define RSVC_NOTCONNECTED   5  /* not connected to low network service     */
#define RSVC_IOFAILED       6  /* low level network service IO failed      */
#define RSVC_CONFLICT       7  /* conflicts of data types or tags          */
#define RSVC_NOTFOUND       8  /* RSVC cannot find user request (RSVCData) */

#define RSVC_TIMEOUT        9  /* time out                                 */
#define RSVC_CONVERT       10  /* RSVCData conversion error                */
#define RSVC_OUTOFRANGE    11  /* value out of range for device attribute  */
#define RSVC_NOACCESS      12  /* insufficient access to perform request   */
#define RSVC_ACCESSCHANGED 13  /* change in access permission of device    */

#define RSVC_DISCONNECTED  60  /* channel has been disconnected         */
#define RSVC_RECONNECTED   61  /* channel has been reconnected          */
#define RSVC_OVERFLOW      62  /* overflow existing data buffer         */

#define RSVC_DELETE_CALLBACK 70 /* the callback object will be deleted   */

#define RSVC_NOKEY          80 /* data has no key in the data               */
#define RSVC_CONN_TIMEOUT   82 /* connection timeout                        */
#define RSVC_FILTERED       83 /* messages have been filtered               */
#define RSVC_NOFILTERING    84 /* no filtering applied                      */
#define RSVC_DROPPED        85 /* message is dropped                        */
#define RSVC_BADIO          86 /* TCP io is bad file descriptor             */
#define RSVC_INCOMPLETE     88 /* data flow will coming (unfinished)        */
#define RSVC_CBK_FINISHED   89 /* callback finished (monitor off)           */
#define RSVC_PAUSED         90 /* query callback is paused                  */
#define RSVC_QUERYMSG_ERR   91 /* query message syntax error                */

/* Request object state values                                             */
#define RSVC_STATE_CONNECTED    0 /* request object is connected to device */
#define RSVC_STATE_NOTCONNECTED 1 /* request object is not connected       */
#define RSVC_STATE_INVALID      2 /* request object is invalid             */

/* Request object access values                                            */
#define RSVC_ACCESS_NONE        0 /* no access to specified attribute      */
#define RSVC_ACCESS_READONLY    1 /* read-only access to attribute         */
#define RSVC_ACCESS_WRITE       2 /* read-write access to attribute        */

/* RSVCError class severity codes                                          */
#define RSVC_SEVERITY_INFO      0 /* informative message                   */
#define RSVC_SEVERITY_WARN      1 /* warning message                       */
#define RSVC_SEVERITY_ERROR     2 /* error message                         */
#define RSVC_SEVERITY_SEVERE    3 /* severe or fatal error message         */

#define RSVC_IOERROR        RSVC_IOFAILED


#endif
