#ifndef _VIRTUAL_SERVER_H_
#define _VIRTUAL_SERVER_H_ 1

#include <cdevServer.h>
#include <StringHash.h>
#include <cdevMonitorTable.h>

// *****************************************************************************
// * class VirtualServer :
// *	This is the server class for the VirtualDevice.  It simply receives 
// *	messages from a client and immediately returns them.
// *
// *	The constructor passes the domain, server, port and rate to the
// *	underlying cdevServer class to be processed.  The cdevServer constructor
// *	will add this server to the Name Server and will begin processing 
// *	messages when the cdevServer::runServer() method is executed.
// *
// *	The processMessages method is the servers interface to the world... Each
// *	time a complete message is received or the time specified in rate
// *	expires, that method will be called.
// *****************************************************************************
class VirtualServer : public cdevServer, public cdevMonitorTable
{
private:
	StringHash attribHash;
	
public:
	VirtualServer ( char * domain, char * server, unsigned int port, double pulse )
		: cdevServer(domain, server, port, pulse), attribHash()
		{
		populateTable();
		}

	virtual     ~VirtualServer   ( void );
	virtual void processMessages ( void );	
	void         populateTable   ( void );
	virtual int fireCallback     ( cdevMessage * message );
};

#endif
