#! /bin/csh

if ( $?CDEV == 0 ) then
	echo "CDEV Environment Variable is NOT Defined"
	exit 0
endif

if ( $?CDEVDDL ) then
	setenv OLDCDEVDDL $CDEVDDL
endif

setenv CDEVDDL `pwd`/Reflector.ddl

echo "-------------------------------------------------------------------------"
echo " This test will send a collection of packets to the Reflector Server...  "
echo " The Server should return the same data to the client unmodified.        "
echo "-------------------------------------------------------------------------"

cdevUtil "debug on" \
	 "device1 get attrib1 value=0 status=1 controlHigh=2 controlLow=3 alarmHigh=4 alarmLow=5" \
 	 "device1 get attrib2 value=10 status=11 controlHigh=12 controlLow=13 alarmHigh=14 alarmLow=15" \
 	 "device1 get attrib3 value=20 status=21 controlHigh=22 controlLow=23 alarmHigh=24 alarmLow=25" \
 	 "device1 get attrib4 value=30 status=31 controlHigh=32 controlLow=33 alarmHigh=34 alarmLow=35" \
 	 "device1 get attrib5 value=40 status=41 controlHigh=42 controlLow=43 alarmHigh=44 alarmLow=45" \
 	 "device1 get attrib6 value=50 status=51 controlHigh=52 controlLow=53 alarmHigh=54 alarmLow=55" \
	 "device2 get attrib1 value=0 status=1 controlHigh=2 controlLow=3 alarmHigh=4 alarmLow=5" \
 	 "device2 get attrib2 value=10 status=11 controlHigh=12 controlLow=13 alarmHigh=14 alarmLow=15" \
 	 "device2 get attrib3 value=20 status=21 controlHigh=22 controlLow=23 alarmHigh=24 alarmLow=25" \
 	 "device2 get attrib4 value=30 status=31 controlHigh=32 controlLow=33 alarmHigh=34 alarmLow=35" \
 	 "device2 get attrib5 value=40 status=41 controlHigh=42 controlLow=43 alarmHigh=44 alarmLow=45" \
 	 "device2 get attrib6 value=50 status=51 controlHigh=52 controlLow=53 alarmHigh=54 alarmLow=55" \
	 "device3 get attrib1 value=0 status=1 controlHigh=2 controlLow=3 alarmHigh=4 alarmLow=5" \
 	 "device3 get attrib2 value=10 status=11 controlHigh=12 controlLow=13 alarmHigh=14 alarmLow=15" \
 	 "device3 get attrib3 value=20 status=21 controlHigh=22 controlLow=23 alarmHigh=24 alarmLow=25" \
 	 "device3 get attrib4 value=30 status=31 controlHigh=32 controlLow=33 alarmHigh=34 alarmLow=35" \
 	 "device3 get attrib5 value=40 status=41 controlHigh=42 controlLow=43 alarmHigh=44 alarmLow=45" \
 	 "device3 get attrib6 value=50 status=51 controlHigh=52 controlLow=53 alarmHigh=54 alarmLow=55" \
 	 "quit" 

if ( $?OLDCDEVDDL ) then
	setenv CDEVDDL $OLDCDEVDDL
endif

echo "-------------------------------------------------------------------------"
echo " End of test..."
echo "-------------------------------------------------------------------------"
