#include <ReflectorService.h>

// *****************************************************************************
// * newReflectorService:
// *	This function will be called by the cdevSystem object to create an 
// *	initial instance of the ReflectorService.
// *****************************************************************************
extern "C" cdevService * newReflectorService (char * name, cdevSystem * system)
	{
	return new ReflectorService(name, *system);
	}

// *****************************************************************************
// * ReflectorService::ReflectorService :
// *	This is teh constructor for the ReflectorService.  It initializes the
// *	underlying cdevClientService by specifying that it is in the domain of
// *	REFLECTOR.
// *****************************************************************************
ReflectorService::ReflectorService ( char * name, cdevSystem & system)
	: cdevClientService("REFLECTOR", name, system) 
	{
	system.reportError(CDEV_SEVERITY_INFO, "ReflectorService", NULL, 
			   "Constructing a new ReflectorService"); 
	}
