.SUFFIXES: .cc .obj

APPNAME     = CDEV Generic Server Engine
ARCH        = WINNT-4.0

TEMPLINKS   = cdevPacket.cc\
              cdevMessageBinary.cc\
			  cdevMessage.cc\
			  cdevContextMap.cc\
			  cdevTagMap.cc\
			  cdevMonitorTable.cc\
			  SignalManager.cc\
			  cdevAddr.cc\
			  cdevEventHandler.cc\
			  cdevHandleSet.cc\
			  cdevReactor.cc\
			  cdevSocket.cc\
			  cdevSocketAcceptor.cc\
			  cdevSocketConnector.cc\
			  cdevSocketDatagram.cc\
			  cdevSocketStream.cc\
			  cdevStreamNode.cc\
			  cdevStreamQueue.cc\
			  cdevTime.cc\
			  fifo.cc
		 
BINARIES    = $(CDEVLIB)\cdevServer.dll \
              $(CDEVLIB)\cdevServer.lib \
			  $(TEMPLINKS)

include ..\include\makeinclude\Makefile.WINNT-4.0

SERVER_OBJS    = $(OBJDIR)\cdevServer.obj\
                 $(OBJDIR)\cdevServerTools.obj\
                 $(OBJDIR)\cdevSessionManager.obj\
                 $(OBJDIR)\ClientHandler.obj\
                 $(OBJDIR)\ClientAcceptor.obj\
				 $(OBJDIR)\cdevTagMap.obj\
                 $(OBJDIR)\cdevMonitorTable.obj

COMMON_OBJS    = $(OBJDIR)\cdevPacket.obj\
                 $(OBJDIR)\cdevMessageBinary.obj\
                 $(OBJDIR)\cdevMessage.obj\
                 $(OBJDIR)\cdevContextMap.obj\
                 $(OBJDIR)\SignalManager.obj\
				 $(OBJDIR)\fifo.obj

ACE_OBJS       = $(OBJDIR)\cdevAddr.obj\
				 $(OBJDIR)\cdevEventHandler.obj\
				 $(OBJDIR)\cdevHandleSet.obj\
				 $(OBJDIR)\cdevReactor.obj\
				 $(OBJDIR)\cdevSocket.obj\
				 $(OBJDIR)\cdevSocketAcceptor.obj\
				 $(OBJDIR)\cdevSocketConnector.obj\
				 $(OBJDIR)\cdevSocketDatagram.obj\
				 $(OBJDIR)\cdevSocketStream.obj\
				 $(OBJDIR)\cdevStreamNode.obj\
				 $(OBJDIR)\cdevStreamQueue.obj\
				 $(OBJDIR)\cdevTime.obj
OBJS           = $(SERVER_OBJS) $(COMMON_OBJS) $(ACE_OBJS)

CXXEXTRA       = /D "_CDEV_REACTOR_EXPORTS_=1" /D "_GENERIC_SERVER_EXPORTS_=1"

!IF "$(SHOBJ)" == "YES"
TARGETS = $(TEMPLINKS) $(CDEVLIB)\cdevServer.dll
!ELSE
TARGETS = $(TEMPLINKS) $(CDEVLIB)\cdevServer.lib
!ENDIF

targets : $(TARGETS)
	@erase $(TEMPLINKS) 
	
$(CDEVLIB)\cdevServer.lib : $(OBJS)
	@echo ^ ^ ^ =^> Linking $(@F) 
	-@if exist $@ erase $@
	-@if not exist $(@D) mkdir $(@D)
	@$(LIB32) $(CDEVLIB)\cdev.lib $(CDEVLIB)\rsvc.lib\
	$(LINK_LIB_FLAGS) /out:$@ $(OBJS)
	@echo ^ ^ ^ ^ ^ ^ Done...

$(CDEVLIB)\cdevServer.dll : $(OBJS)
	@echo ^ ^ ^ =^> Linking $(@F) 
	-@if exist $@ erase $@
	-@if not exist $(@D) mkdir $(@D)
	@$(LIB32) $(CDEVLIB)\cdev.lib $(CDEVLIB)\rsvc.lib\
	$(LINK_DLL_FLAGS) /out:$@ /implib:$(@D)\$(@B).lib $(OBJS)
	@echo ^ ^ ^ ^ ^ ^ Done...

cdevMessage.cc			: ..\cdevPacket\cdevMessage.cc
	-@$(CREATE_LINK)
	
cdevMessageBinary.cc	: ..\cdevPacket\cdevMessageBinary.cc
	-@$(CREATE_LINK)
	
cdevPacket.cc			: ..\cdevPacket\cdevPacket.cc
	-@$(CREATE_LINK)
	
cdevContextMap.cc		: ..\cdevContextMap\cdevContextMap.cc
	-@$(CREATE_LINK)
	
SignalManager.cc		: ..\common\SignalManager.cc
	-@$(CREATE_LINK)
	
cdevAddr.cc				: ..\cdevReactor\cdevAddr.cc
	-@$(CREATE_LINK)
	
cdevEventHandler.cc		: ..\cdevReactor\cdevEventHandler.cc
	-@$(CREATE_LINK)
	
cdevHandleSet.cc		: ..\cdevReactor\cdevHandleSet.cc
	-@$(CREATE_LINK)
	
cdevReactor.cc			: ..\cdevReactor\cdevReactor.cc
	-@$(CREATE_LINK)
	
cdevSocket.cc			: ..\cdevReactor\cdevSocket.cc
	-@$(CREATE_LINK)
	
cdevSocketAcceptor.cc	: ..\cdevReactor\cdevSocketAcceptor.cc
	-@$(CREATE_LINK)
	
cdevSocketConnector.cc	: ..\cdevReactor\cdevSocketConnector.cc
	-@$(CREATE_LINK)
	
cdevSocketDatagram.cc	: ..\cdevReactor\cdevSocketDatagram.cc
	-@$(CREATE_LINK)
	
cdevSocketStream.cc		: ..\cdevReactor\cdevSocketStream.cc
	-@$(CREATE_LINK)
	
cdevStreamNode.cc		: ..\cdevReactor\cdevStreamNode.cc
	-@$(CREATE_LINK)
	
cdevStreamQueue.cc		: ..\cdevReactor\cdevStreamQueue.cc
	-@$(CREATE_LINK)
	
cdevTime.cc				: ..\cdevReactor\cdevTime.cc
	-@$(CREATE_LINK)
	
fifo.cc					: ..\common\fifo.cc
	-@$(CREATE_LINK)
	
cdevTagMap.cc			: ..\cdevTagMap\cdevTagMap.cc
	-@$(CREATE_LINK)
	
cdevMonitorTable.cc		: ..\cdevMonitorTable\cdevMonitorTable.cc
	-@$(CREATE_LINK)
	
	
