#ifndef _CDEV_STREAM_NODE_H_
#define _CDEV_STREAM_NODE_H_

#include "cdevPlatforms.h"

// *****************************************************************************
// * class cdevStreamNode :
// *	This is a virtual base class that defines the functionality that will 
// *	be required for data nodes that are inserted into the 
// *	cdevBufferedSocket.
// *****************************************************************************
class CDEV_REACTOR_API cdevStreamNode
{
friend class cdevStreamQueue;

public:
	virtual ~cdevStreamNode ( void );
		 
	virtual size_t getLen(void) const              = 0;
	virtual void   setLen(size_t size)             = 0;
	virtual char * getBuf(void) const              = 0;
	virtual void   setBuf(char * buf, size_t len)  = 0;

protected:
	cdevStreamNode * nextStreamNode;
		
	cdevStreamNode ( void );

	cdevStreamNode * getNext( void ) const;
	void setNext(cdevStreamNode * node);
};

#endif /* _CDEV_STREAM_NODE_H_ */
