#ifndef _CDEV_SOCKET_H_
#define _CDEV_SOCKET_H_

#include <stdio.h>
#include <fcntl.h>
#include "cdevAddr.h"

class CDEV_REACTOR_API cdevSocket
{
protected:
	int         handle;
	sockaddr_in sa;	
	
	cdevSocket(void);
	cdevSocket(int type, int protocol_family, int protocol=0);

public:
	enum {INVALID_HANDLE=-1};

	void setHandle        (int fd);
	int  getHandle        (void) const;
	int  open             (int type, int protocol_family, int protocol);
	int  close            (void);
	int  unsetFlags       (int flags);
	int  setFlags         (int flags);
	int  getFlags         (void); 
	int  setOption        (int level, int option, void *optval, int optlen) const;
	int  getOption        (int level, int option, void *optval, int *optlen) const;
	int  getLocalAddress  (cdevAddr & address);
	int  getRemoteAddress (cdevAddr & address);
};


#endif
